package com.biz.crm.mdm.business.terminal.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 门店供货关系明细dto
 *
 * @author sunx
 * @since 2021-10-19 13:55:08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TerminalSupplyDetailDto", description = "门店供货关系明细dto")
public class TerminalSupplyDetailDto extends TenantDto {

  /** 类型1商品2产品层级 */
  @ApiModelProperty("类型1商品2产品层级")
  private String dataType;

  /** 编码 */
  @ApiModelProperty("编码")
  private String code;

  /** 描述 */
  @ApiModelProperty("描述")
  private String name;

  /** 供货关系id */
  @ApiModelProperty("供货关系id")
  private String supplyId;
}
