package com.biz.crm.mdm.business.terminal.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 终端业务员dto
 *
 * @author sunx
 * @since 2021-10-19 13:54:40
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TerminalSupplyDto", description = "终端业务员dto")
public class TerminalSupplyDto extends TenantDto {

  /** 供货关系类型 */
  @ApiModelProperty("供货关系类型,TerminalSupplyTypeEnum: default-默认，customer_user-客户用户")
  private String supplyType;

  /** 用户账号 */
  @ApiModelProperty("用户账号")
  private String userName;

  /** 用户编码 */
  @ApiModelProperty("用户编码")
  private String userCode;

  /** 终端编码 */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /** 组织编码 */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /** 上级客户编码 */
  @ApiModelProperty("上级客户编码")
  private String customerCode;

  /** 职位编码 */
  @ApiModelProperty("职位编码")
  private String positionCode;

  /** 销售公司编码 */
  @ApiModelProperty("销售公司编码")
  private String saleCompany;

  /** 渠道 */
  @ApiModelProperty("渠道")
  private String channel;

  /** 渠道名称 */
  @ApiModelProperty("渠道名称")
  private String channelName;

  @ApiModelProperty("供货关系明细")
  private List<TerminalSupplyDetailDto> details;
}
