package com.biz.crm.mdm.business.terminal.sdk.service;

import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalSupplyDto;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;

/**
 * @author sunx
 * @date 2021/10/19
 */
public interface TerminalSupplyVoService {

  /**
   * 根据终端编码集合获取匹配信息
   *
   * @param terminalCodeList
   * @return
   */
  default List<TerminalSupplyVo> findByTerminalCodes(List<String> terminalCodeList) {
    return Lists.newLinkedList();
  }

  /**
   * 批量保存供货关系
   *
   * @param list
   * @param terminalCode
   */
  default void saveBatch(List<TerminalSupplyDto> list, String terminalCode) {}

  /**
   * 根据终端编码删除信息
   *
   * @param terminalCodes
   */
  default void deleteByTerminalCodes(List<String> terminalCodes) {}

  /**
   * 获取终端指定物料的供货经销商编码集合
   *
   * @param terminalCode
   * @param materialCode 物料编码，需要根据物料反向查找商品，及对应的层级及上级层级编码集合
   * @return
   */
  default Set<String> findTerminalSupplyCustomerCodeSet(String terminalCode, String materialCode) {
    return Sets.newHashSet();
  }
}
