package com.biz.crm.mdm.business.terminal.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalCodeSearchDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalPaginationDto;
import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalQueryDto;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.domain.Pageable;

/**
 * 终端信息Vo接口
 *
 * @author sunx
 * @since 2021-10-19 13:53:14
 */
public interface TerminalVoService {

  /**
   * 根据id或编码集合获取详情集合
   *
   * @param ids
   * @param terminalCodes
   * @return
   */
  List<TerminalVo> findDetailsByIdsOrTerminalCodes(List<String> ids, List<String> terminalCodes);

  /**
   * 创建
   *
   * @param dto
   * @return
   */
  TerminalVo create(TerminalDto dto);

  /**
   * 创建
   *
   * @param dto
   * @return
   */
  default TerminalVo createAndSubmit(TerminalDto dto) {
    return null;
  }

  /**
   * 更新
   *
   * @param dto
   * @return
   */
  TerminalVo update(TerminalDto dto);

  /**
   * 关键字模糊查询获得下拉数据
   *
   * @param keyword
   * @return
   */
  default List<TerminalVo> findSelectByKeyword(String keyword) {
    return Lists.newLinkedList();
  }

  /**
   * 根据编码获取终端主信息+组织信息+联系人
   *
   * @param terminalCodeList
   * @return
   */
  default List<TerminalVo> findMainDetailsByTerminalCodes(List<String> terminalCodeList) {
    return Lists.newLinkedList();
  }

  /**
   * 分页条件查询
   *
   * @param pageable 分页参数
   * @param dto 参数dto
   * @return 终端分页信息
   */
  default Page<TerminalVo> findByTerminalPaginationDto(
      Pageable pageable, TerminalPaginationDto dto) {
    return null;
  }

  /**
   * 根据组织、渠道、标签获取匹配的终端编码
   *
   * @param dto
   * @return
   */
  default Set<String> findByTerminalCodeSearchDto(TerminalCodeSearchDto dto) {
    return Sets.newHashSet();
  }

  /**
   * 根据高德id集合查询数据集合
   *
   * @param amapIds
   * @return
   */
  default List<TerminalVo> findByAmapIds(Set<String> amapIds) {
    return Lists.newArrayList();
  }

  /**
   * 提交审核
   *
   * @param dto
   */
  default void submitAudit(TerminalDto dto) {}

  /**
   * 根据TerminalQueryDto获取对应的终端编码集合
   *
   * @param dto
   * @return
   */
  default Set<String> findByTerminalQueryDto(TerminalQueryDto dto){
    return Sets.newHashSet();
  }

  /**
   * 根据组织获取组织及下级所有的审核通过且未删除的终端信息
   *
   * @param orgCodes
   * @return k-终端编码，v-关联组织对应的降维码集合
   */
  default Map<String, Set<String>> findAllowSaleTerminalByOrgCodes(Set<String> orgCodes) {
    return Maps.newHashMap();
  }
}
