package com.biz.crm.mdm.business.terminal.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 终端业务员vo
 *
 * @author sunx
 * @since 2021-10-19 13:54:41
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "终端业务员Vo")
public class TerminalSupplyVo extends TenantVo {
  private static final long serialVersionUID = -1074993803426058296L;

  /**
   * 供货关系类型
   */
  @ApiModelProperty("供货关系类型")
  private String supplyType;

  /**
   * 用户账号
   */
  @ApiModelProperty("用户账号")
  private String userName;

  /**
   * 用户名称
   */
  @ApiModelProperty("用户名称")
  private String fullName;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 组织编码
   */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /**
   * 组织
   */
  @ApiModelProperty("组织")
  private String orgName;

  /**
   * 上级客户编码
   */
  @ApiModelProperty("上级客户编码")
  private String customerCode;

  /**
   * 上级客户
   */
  @ApiModelProperty("上级客户")
  private String customerName;

  /**
   * 职位编码
   */
  @ApiModelProperty("职位编码")
  private String positionCode;

  /**
   * 职位名称
   */
  @ApiModelProperty("职位名称")
  private String positionName;

  /**
   * 组织名称/职位名称/用户名称
   */
  @ApiModelProperty("组织名称/职位名称/用户名称")
  private String unionName;

  /**
   * 销售公司编码
   */
  @ApiModelProperty("销售公司编码")
  private String saleCompany;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * 渠道名称
   */
  @ApiModelProperty("渠道名称")
  private String channelName;

  @ApiModelProperty("供货关系明细")
  private List<TerminalSupplyDetailVo> details;
}
