package com.biz.crm.mdm.business.terminal.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;

/**
 * 终端扩展信息dto
 *
 * @author sunx
 * @since 2021-10-19 13:53:46
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TerminalContactDto", description = "终端扩展信息dto")
public class TerminalContactDto extends TenantDto {

  /** 终端编码 */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /** 联系人姓名 */
  @ApiModelProperty("联系人姓名")
  private String contactName;

  /** 联系人电话 */
  @ApiModelProperty("联系人电话")
  private String contactPhone;

  /** 主联系人,true是,false否 */
  @ApiModelProperty("主联系人,true是,false否")
  private Boolean contactMain;

  /** 身份证号 */
  @ApiModelProperty("身份证号")
  private String idNumber;

  @ApiModelProperty("实人认证状态")
  private String verifyStatus;

  /**
   * 实人认证时间
   */
  @ApiModelProperty("实人认证时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date verifyTime;

  @ApiModelProperty("微信unionID")
  private String weChatUnionId;

  @ApiModelProperty("微信认证状态")
  private String weChatVerifyStatus;

  /**
   * 微信认证时间
   */
  @ApiModelProperty("微信认证时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date weChatVerifyTime;
}
