package com.biz.crm.mdm.business.terminal.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Set;

/**
 * 根据TerminalQueryDto获取匹配的终端编码
 *
 * @author sunx
 * @date 2022/5/27
 */
@Data
public class TerminalDistanceQueryDto extends TenantFlagOpDto {
  /** 终端编码模糊查询 */
  private String terminalCode;
  /** 终端名称模糊查询 */
  private String terminalName;
  /** 渠道编码 */
  private String channel;
  /** 组织名称模糊查询 */
  private String orgName;
  /** 删除标记 */
  private String delFlag = DelFlagStatusEnum.NORMAL.getCode();
  /** 审核状态 */
  private String processStatus = ProcessStatusEnum.PASS.getDictCode();
  /** 终端编码集合查询 */
  private Set<String> terminalCodeSet;
  /** 组织编码集合 */
  private Set<String> orgCodeSet;

  /**
   * 搜索关键字
   */
  private String keyWord;

  /**
   * 经度
   */
  private BigDecimal longitude;

  /**
   * 纬度
   */
  private BigDecimal latitude;

  /**
   * 大区
   */
  private String regionCode;

  /**
   * 省区
   */
  private String provinceCode;

  /**
   * 市场
   */
  private String channelCode;

  /**
   * 人员
   */
  private String userName;

  /**
   * 渠道类型
   */
  private String channels;

  /**
   * 门店类型
   */
  private String twoChannels;

  /**
   * 终端等级
   */
  private String terminalLevels;

  /**
   * 高德MAP ID
   */
  private Set<String> amapIds;

  /**
   * 距离
   */
  private Integer distance;

  private Integer page;
  private Integer size;

  @ApiModelProperty("业态编码")
  private String formatCode;
}
