package com.biz.crm.mdm.business.terminal.sdk.dto;

import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * 终端信息分页查询dto
 *
 * @author sunx
 * @since 2021-10-19 13:53:12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TerminalPaginationDto", description = "终端信息分页查询dto")
public class TerminalPaginationDto extends TenantFlagOpDto {
  /** 组织编码 */
  @ApiModelProperty("组织编码")
  private String orgCode;
  /** 客户组织编码 */
  @ApiModelProperty("客户组织编码")
  private String customerOrgCode;
  /** 终端编码 */
  @ApiModelProperty("终端编码")
  private String terminalCode;
  /** 终端名称 */
  @ApiModelProperty("终端名称")
  private String terminalName;
  /** 终端类型 */
  @ApiModelProperty("终端类型")
  private String terminalType;
  /** 编码名称模糊查询 */
  @ApiModelProperty("编码名称模糊查询")
  private String keyword;
  /** 不包含门店编码查询条件 * */
  @ApiModelProperty("不包含门店编码查询条件")
  private List<String> notIncludeTerminalCodeList;
  /** 不包含门店编码查询条件 * */
  @ApiModelProperty("标签名称")
  private String tagName;
  /** 渠道 * */
  @ApiModelProperty("渠道")
  private String channel;
  /** 组织编码集合 */
  @ApiModelProperty("组织编码集合")
  private String orgCodeList;
  /** 营业注册号 */
  @ApiModelProperty("营业注册号")
  private String licenseRegisterNumber;
  /** 终端地址 */
  @ApiModelProperty("终端地址")
  private String terminalAddress;
  /** 审批状态 */
  @ApiModelProperty("审批状态")
  private String processStatus;
  /**回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据*/
  @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
  private List<String> selectedCode;
  @ApiModelProperty("上级客户编码")
  private String parentCustomerCode;
  @ApiModelProperty("上级客户名称")
  private String parentCustomerName;
  @ApiModelProperty("区域编码")
  private String regionCode;
  @ApiModelProperty("零售商编码")
  private String customerRetailerCode;

  /**
   * 业务单元[数据字典:mdm_business_unit]
   */
  @ApiModelProperty( "业务单元[数据字典:mdm_business_unit]")
  private String businessUnitCode;

  /**
   * 业态编码
   */
  @ApiModelProperty("业态编码")
  private String businessFormatCode;
  /**

  /**
   * 分仓名称
   */
  @ApiModelProperty("分仓名称")
  private String pointsWarehouseName;

  /**
   * 分仓编码
   */
  @ApiModelProperty("分仓编码")
  private String pointsWarehouseCode;

  /**
   * 城市级别编码
   */
  @ApiModelProperty("城市级别编码")
  private String districtLevelCode;

  /**
   * 城市级别名称
   */
  @ApiModelProperty("城市级别名称")
  private String districtLevelName;

  /**
   * AC终端类型编码
   */
  @ApiModelProperty("AC终端类型编码")
  private String terminalTypeCode;

  /**
   * AC终端类型名称
   */
  @ApiModelProperty("AC终端类型名称")
  private String terminalTypeName;

  @ApiModelProperty("终端状态")
  private String terminalState;

  /**
   * 是否送达方
   */
  @ApiModelProperty("是否送达方")
  private String settleDestination;

  /**
   * 所属销售机构编码
   */
  @ApiModelProperty("所属销售机构编码")
  private String salesInstitutionCode;
}
