package com.biz.crm.mdm.business.terminal.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 门店通过区域+零售商+城市查询dto
 *
 * @author chenlong
 * @since 2021-10-19 13:53:12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TerminalRegionRetailerCityDto", description = "门店通过区域+零售商+城市查询dto")
public class TerminalRegionRetailerCityDto extends TenantFlagOpDto {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "businessFormatCode", name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "businessUnitCode", name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 区域编码列表
     */
    @ApiModelProperty(value = "regionCodeList", name = "区域编码列表", notes = "区域编码列表")
    private List<String> regionCodeList;

    /**
     * 零售商编码列表
     */
    @ApiModelProperty(value = "retailerCodeList", name = "零售商编码列表", notes = "零售商编码列表")
    private List<String> retailerCodeList;

    /**
     * 城市名称列表
     */
    @ApiModelProperty(value = "cityNameList", name = "城市名称列表", notes = "城市名称列表")
    private List<String> cityNameList;


}
