package com.biz.crm.mdm.business.terminal.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Set;

/**
 * 组合条件查询对应的终端信息dto
 *
 * @author ning.zhang
 * @date 2022/8/2
 */
@Data
@ApiModel(value = "TerminalCodeSearchDto", description = "组合条件查询对应的终端信息dto")
public class TerminalSearchDto {
  /** 组织编码 */
  @ApiModelProperty("组织编码")
  private Set<String> orgCodeSet;
  /** 渠道编码集合 */
  @ApiModelProperty("渠道编码集合")
  private Set<String> channelSet;
  /** 标签集合 */
  @ApiModelProperty("标签集合")
  private Set<String> tagSet;
  /** 终端编码集合 */
  @ApiModelProperty("终端编码集合")
  private Set<String> terminalCodeSet;
  /** 数据状态（删除状态） */
  @ApiModelProperty("删除状态")
  private String delFlag;
  /** 数据业务状态（启用状态） */
  @ApiModelProperty("启用状态")
  private String enableStatus;
  /** 审批状态 */
  @ApiModelProperty("审批状态")
  private String processStatus;
  /** 租户编号 */
  @ApiModelProperty("租户编号")
  private String tenantCode;
}
