package com.biz.crm.mdm.business.terminal.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.vo.AttachmentVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 门店售达方dto
 *
 * @author chenlong
 * @since 2021-10-19 13:53:13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TerminalSellingPartyDto", description = "门店售达方dto")
public class TerminalSellingPartyDto extends TenantFlagOpDto {

  /**
   * 售达方编码(字段名与kms一致，方便数据权限使用)
   */
  @ApiModelProperty("售达方编码")
  private String soldToPartyCode;

  /**
   * 售达方名称(字段名与kms一致，方便数据权限使用)
   */
  @ApiModelProperty("售达方名称")
  private String soldToPartyName;

}
