package com.biz.crm.mdm.business.terminal.sdk.enums;

import java.util.Optional;
import java.util.stream.Stream;
import lombok.Getter;

/**
 * @author sunx
 * @date 2021/11/4
 */
@Getter
public enum TerminalSupplyTypeEnum {
  /** 供货关系类型 */
  DEFAULT("default", "默认"),
  CUSTOMER_USER("customer_user", "客户用户"),
  ;

  private String value;
  private String desc;

  TerminalSupplyTypeEnum(String value, String desc) {
    this.value = value;
    this.desc = desc;
  }

  public static Boolean exists(String value) {
    Optional<TerminalSupplyTypeEnum> first =
        Stream.of(TerminalSupplyTypeEnum.values()).filter(a -> a.value.equals(value)).findFirst();
    return first.isPresent();
  }
}
