package com.biz.crm.mdm.business.terminal.sdk.event;

import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyDetailVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalSupplyVo;
import java.util.List;

/**
 * 终端供货关系变更事件接口
 *
 * @author sunx
 * @date 2021/11/4
 */
public interface TerminalSupplyEventListener {

  /**
   * 重新绑定时触发
   *
   * @param positionCode 岗位编码绑定供货关系
   * @param customerUserName 客户用户绑定终端供货关系
   * @param customerCode 客户绑定终端供货关系
   * @param terminalCodeList 终端编码集合
   */
  default void onBind(
      String positionCode,
      String customerUserName,
      String customerCode,
      List<String> terminalCodeList) {}

  /**
   * 解除绑定时触发
   *
   * @param supplyVoList
   * @param supplyDetailVoList
   */
  default void onUnbind(
      List<TerminalSupplyVo> supplyVoList, List<TerminalSupplyDetailVo> supplyDetailVoList) {}
}
