package com.biz.crm.mdm.business.terminal.sdk.event;

import com.biz.crm.mdm.business.terminal.sdk.vo.SupplyPositionPageVo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;

/**
 * 终端供货关系关联负责人根据岗位获取扩展信息注册器
 *
 * @author sunx
 * @date 2022/3/17
 */
public interface TerminalSupplyPositionRegister {

  /**
   * 根据岗位信息获取组织名称/职位名称/用户名称等信息
   *
   * @param positionCodeSet
   * @return
   */
  default List<SupplyPositionPageVo> onRequestByPositionCodes(Set<String> positionCodeSet) {
    return Lists.newLinkedList();
  }
}
