package com.biz.crm.mdm.business.terminal.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.terminal.sdk.dto.*;
import com.biz.crm.mdm.business.terminal.sdk.vo.CustomerTerminalVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 终端信息Vo接口
 *
 * @author sunx
 * @since 2021-10-19 13:53:14
 */
public interface TerminalVoService {

  /**
   * 根据id或编码集合获取详情集合
   *
   * @param ids
   * @param terminalCodes
   * @return
   */
  List<TerminalVo> findDetailsByIdsOrTerminalCodes(List<String> ids, List<String> terminalCodes);

  /**
   * 根据编码集合获取详情集合 POST
   *
   * @param terminalCodes
   * @return
   */
  List<TerminalVo> findDetailsByTerminalCodesPOST(List<String> terminalCodes);

  /**
   * 创建或更新门店
   *
   * @param dtoList
   * @return
   */
  List<TerminalVo> createOrUpdate(List<TerminalDto> dtoList);

  /**
   * 创建
   *
   * @param dto
   * @return
   */
  TerminalVo create(TerminalDto dto);

  /**
   * 创建
   *
   * @param dto
   * @return
   */
  default TerminalVo createAndSubmit(TerminalDto dto) {
    return null;
  }

  /**
   * 更新
   *
   * @param dto
   * @return
   */
  TerminalVo update(TerminalDto dto);

  /**
   * 关键字模糊查询获得下拉数据
   *
   * @param keyword
   * @return
   */
  default List<TerminalVo> findSelectByKeyword(String keyword) {
    return Lists.newLinkedList();
  }

  /**
   * 根据编码获取终端主信息+组织信息+联系人
   *
   * @param terminalCodeList
   * @return
   */
  default List<TerminalVo> findMainDetailsByTerminalCodes(List<String> terminalCodeList) {
    return Lists.newLinkedList();
  }

  /**
   * 用于Feign  改成post请求
   * 根据编码获取终端主信息+组织信息+联系人
   *
   * @param terminalCodeList
   * @return
   */
  default List<TerminalVo> findMainDetailsByTerminalCodesUsePost(List<String> terminalCodeList) {
    return Lists.newLinkedList();
  }

  /**
   * 用于Feign  改成post请求
   * 根据终端编码集合获取终端主信息+联系人
   *
   * @param terminalCodeList
   * @return
   */
  default List<TerminalVo> findTerminalAndContactByTerminalCodes(List<String> terminalCodeList) {
    return Lists.newLinkedList();
  }

  /**
   * 分页条件查询
   *
   * @param pageable 分页参数
   * @param dto      参数dto
   * @return 终端分页信息
   */
  default Page<TerminalVo> findByTerminalPaginationDto(
          Pageable pageable, TerminalPaginationDto dto) {
    return null;
  }

  /**
   * 根据组织、渠道、标签获取匹配的终端编码
   *
   * @param dto
   * @return
   */
  default Set<String> findByTerminalCodeSearchDto(TerminalCodeSearchDto dto) {
    return Sets.newHashSet();
  }

  /**
   * 根据高德id集合查询数据集合
   *
   * @param amapIds
   * @return
   */
  default List<TerminalVo> findByAmapIds(Set<String> amapIds) {
    return Lists.newArrayList();
  }

  /**
   * 提交审核
   *
   * @param dto
   */
  default void submitAudit(TerminalDto dto) {
  }

  /**
   * 根据TerminalQueryDto获取对应的终端编码集合
   *
   * @param dto
   * @return
   */
  default Set<String> findByTerminalQueryDto(TerminalQueryDto dto) {
    return Sets.newHashSet();
  }

  /**
   * 根据组织获取组织及下级所有的审核通过且未删除的终端信息
   *
   * @param orgCodes
   * @return k-终端编码，v-关联组织对应的降维码集合
   */
  default Map<String, Set<String>> findAllowSaleTerminalByOrgCodes(Set<String> orgCodes) {
    return Maps.newHashMap();
  }

  /**
   * 根据组织、渠道、标签获取匹配的终端基本信息
   *
   * @param dto 参数dto
   * @return 终端基本信息
   */
  default List<TerminalVo> findByTerminalSearchDto(TerminalSearchDto dto) {
    return Lists.newLinkedList();
  }

  /**
   * 根据客户编码列表获取关联的门店及下级门店信息
   *
   * @param codeList 客户编码列表
   * @return Map<String, Map < String, String>>
   */
  Map<String, Map<String, String>> findTerminalBycusCodes(@RequestParam("codeList") List<List<String>> codeList);

  /**
   * 获取全部区域数据
   *
   * @return Map<String, String>
   */
  Map<String, String> findTerminalRegion();

  /**
   * 根据区域编码列表获取区域名称
   *
   * @param codes 区域编码
   * @return Map<String, String>
   */
  Map<String, String> findTerminalRegionByCodes(List<String> codes);

  /**
   * 根据终端编码集合获取对应的终端信息
   *
   * @param terminalCodeList 终端编码集合
   * @return 客户信息集合
   */
  List<TerminalVo> findBaseByTerminalCodes(List<String> terminalCodeList);


  /**
   * 条件查询终端信息
   *
   * @param dto
   * @return
   */
  List<TerminalVo> findListByConditions(TerminalPaginationDto dto);

  /**
   * 查询门店通过区域+零售商+城市
   *
   * @param dto 参数
   * @return List<TerminalVo>
   */
  default List<TerminalVo> findListByRegionRetailerCityCodes(TerminalRegionRetailerCityDto dto) {
    return Lists.newArrayList();
  }

  /**
   * 分页条件查询门店基础信息
   *
   * @param pageable 分页参数
   * @param dto      参数dto
   * @return 终端分页信息
   */
  default Page<TerminalVo> findBaseByDto(
          Pageable pageable, TerminalPaginationDto dto) {
    return null;
  }

  /**
   * 根据给定客户（经销商）编号、终端门店编号，查询条件，判断是否满足以上的查询条件，返回Boolean
   *
   * @param terminalCode 终端门店编号
   * @param customerCode 客户（经销商）编号
   * @param dto          查询条件
   * @return 是否满足以上的查询条件
   */
  default Boolean validateCustomerAndTerminal(String terminalCode,
                                              String customerCode,
                                              CustomerTerminalValidateDto dto) {
    return true;
  }

  /**
   * 根据查询条件，返回终端距离等信息
   *
   * @param dto
   * @return
   */
  default Page<TerminalVo> findTerminalDistanceByTerminalQueryDto(TerminalDistanceQueryDto dto) {
    return new Page<>();
  }

  /**
   * 获取指定客户的门店列表
   *
   * @param dto 客户编码 + 终端编码组合的集合
   * @return 指定客户的门店列表
   */
  default List<CustomerTerminalVo> getCustomerTerminalList(List<CustomerTerminalQueryDto> dto) {
    return new ArrayList<>();
  }

}
