package com.biz.crm.mdm.business.terminal.sdk.strategy;

import java.util.Map;

/**
 * 已完成日期维度类型客户统计策略
 *
 * @author songjingen
 * @date 2022/9/7
 */
public interface CompletedCountStrategy {

  /**
   * 日期类型：month,week,day
   *
   * @return
   */
  String dateType();

  /**
   * 根据人员账号获取对应日期类型的已完成客户数
   *
   * @param createAccount 创建人账号
   * @param fromType      业务系统类型
   * @return {"terminal":"已完成数量","dealer":"已完成数量","total":"总数量"}
   */
  Map<String, Integer> findCountByCreateAccountAndFromType(String createAccount, String fromType);
}
