package com.biz.crm.mdm.business.terminal.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.UuidFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * 终端上级客户员工信息Vo
 *
 * @author liangxin
 * @since 2023/3/9
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "终端上级客户员工信息Vo")
public class TerminalCustomerStaffVo extends UuidFlagOpDto {
  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 员工号
   */
  @ApiModelProperty("员工号")
  private String staffCode;

  /**
   * 员工姓名
   */
  @ApiModelProperty("员工姓名")
  private String staffName;

  /**
   * 员工手机
   */
  @ApiModelProperty("员工手机")
  private String staffPhone;

  /**
   * 员工来源
   */
  @ApiModelProperty("员工来源")
  private String staffSource;

  /**
   * 员工类型
   */
  @ApiModelProperty("员工类型")
  private String staffType;

  @ApiModelProperty("微信unionID")
  private String weChatUnionId;

  @ApiModelProperty("微信认证状态")
  private String weChatVerifyStatus;

  @ApiModelProperty("实人认证状态")
  private String verifyStatus;

}
