package com.biz.crm.mdm.business.terminal.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;
import java.util.List;

/**
 * 终端上级客户信息vo
 *
 * @author liangxin
 * @since 2023/3/7
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "终端上级客户信息vo")
public class TerminalCustomerVo extends TenantFlagOpVo {

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 客户业态编码
   */
  @ApiModelProperty("客户业态")
  private String customerBusinessFormatCode;

  /**
   * 客户业态名称
   */
  @ApiModelProperty("客户业态名称")
  private String customerBusinessFormatName;


  /**
   * 客户渠道编码
   */
  @ApiModelProperty("客户渠道编码")
  private String customerChannelCode;

  /**
   * 客户渠道名称
   */
  @ApiModelProperty("客户渠道名称")
  private String customerChannelName;

  @ApiModelProperty("所属销售机构编码")
  private String salesInstitutionCode;

  @ApiModelProperty("所属销售机构")
  private String salesInstitutionName;

  @ApiModelProperty("所属销售部门编码")
  private String salesDepartmentCode;

  @ApiModelProperty("所属销售部门")
  private String salesDepartmentName;

  @ApiModelProperty("销售组编码")
  private String salesGroupCode;

  @ApiModelProperty("销售组")
  private String salesGroupName;

  @ApiModelProperty("关联蒙牛组织编码")
  private String relatedOrgCode;

  @ApiModelProperty("关联蒙牛组织名称")
  private String relatedOrgName;

  @ApiModelProperty("客户类型")
  private String customerType;

  @ApiModelProperty("归属城市经理")
  private String relatedCityManager;

  @ApiModelProperty("归属RBU经理")
  private String relatedRbuManager;

  @ApiModelProperty("门店二级渠道编码")
  private String customerTerminalSecondTypeCode;

  @ApiModelProperty("门店二级渠道名称")
  private String customerTerminalSecondTypeName;

  @ApiModelProperty("门店一级渠道编码")
  private String customerTerminalFirstTypeCode;

  @ApiModelProperty("门店一级渠道名称")
  private String customerTerminalFirstTypeName;

  @ApiModelProperty("门店等级")
  private String customerTerminalLevel;

  @ApiModelProperty("门店等级名称")
  private String customerTerminalLevelName;

  @ApiModelProperty("服务状态")
  private String serveStatus;

  /**
   * 服务开始日期
   */
  @ApiModelProperty("服务开始日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date serveStartTime;

  /**
   * 服务结束日期
   */
  @ApiModelProperty("服务开始日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date serveEndTime;

  /**
   * 零售商编码
   */
  @ApiModelProperty("零售商编码")
  private String retailerCode;

  /**
   * 零售商名称
   */
  @ApiModelProperty("零售商名称")
  private String retailerName;

  /**
   * 零售商区域编码
   */
  @ApiModelProperty("零售商区域编码")
  private String retailerRegionCode;


  /**
   * 零售商区域名称
   */
  @ApiModelProperty("零售商区域名称")
  private String retailerRegionName;

  /**
   * 零售商内部门店类型
   */
  @ApiModelProperty("零售商内部门店类型")
  private String retailerInternalTerminalType;

  /**
   * 售达方编码
   */
  @ApiModelProperty("售达方编码")
  private String sellerCode;

  /**
   * 售达方名称
   */
  @ApiModelProperty("售达方名称")
  private String sellerName;

  /**
   * 是否送达方
   */
  @ApiModelProperty("是否送达方")
  private String settleDestination;

  /**
   * 送达方编码
   */
  @ApiModelProperty("送达方编码")
  private String deliveryWayCode;

  /**
   * 送达方名称
   */
  @ApiModelProperty("送达方名称")
  private String deliveryWayName;

  /**
   * 区域编码
   */
  @ApiModelProperty("区域编码")
  private String regionCode;

  /**
   * 区域名称
   */
  @ApiModelProperty("区域名称")
  private String regionName;


  /**
   * 零售商内部门店名称
   */
  @ApiModelProperty("零售商内部门店名称")
  private String retailerTerminalName;

  /**
   * 省份编码(业绩所属)
   */
  @ApiModelProperty("省份编码(业绩所属)")
  private String businessProvinceCode;

  /**
   * 省份(业绩所属)
   */
  @ApiModelProperty("省份(业绩所属)")
  private String businessProvinceName;

  /**
   * 市编码(业绩所属)
   */
  @ApiModelProperty("市编码(业绩所属)")
  private String businessCityCode;

  /**
   * 城市(业绩所属)
   */
  @ApiModelProperty("城市(业绩所属)")
  private String businessCityName;

  /**
   * 区编码(业绩所属)
   */
  @ApiModelProperty("区编码(业绩所属)")
  private String businessDistrictCode;

  /**
   * 区县(业绩所属)
   */
  @ApiModelProperty(" 区县(业绩所属)")
  private String businessDistrictName;

  /**
   * AC终端类型编码
   */
  @ApiModelProperty("AC终端类型编码")
  private String terminalTypeCode;

  /**
   * AC终端类型名称
   */
  @ApiModelProperty("AC终端类型名称")
  private String terminalTypeName;

  /**
   * 垂直时间
   */
  @ApiModelProperty("垂直时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date verticalTime;

  /**
   * AC城市级别编码
   */
  @ApiModelProperty("AC城市级别编码")
  private String districtLevelCode;

  /**
   * AC城市级别名称
   */
  @ApiModelProperty("AC城市级别名称")
  private String districtLevelName;

  /**
   * 分仓名称
   */
  @ApiModelProperty("分仓名称")
  private String pointsWarehouseName;

  /**
   * 分仓编码
   */
  @ApiModelProperty("分仓编码")
  private String pointsWarehouseCode;

  /**
   * 终端巡查终端标准名称
   */
  @ApiModelProperty("巡查终端标准名称")
  private String patrolTerminalStandardName;

  /**
   * 是否为巡查门店
   */
  @ApiModelProperty("是否为巡查门店")
  private String settlePatrolTerminal;

  /**
   * DC仓库名称
   */
  @ApiModelProperty("DC仓库名称")
  private String warehouseName;

  /**
   * DC仓库编码
   */
  @ApiModelProperty("DC仓库编码")
  private String warehouseCode;

  /**
   * 业务模式编码
   */
  @ApiModelProperty("业务模式编码")
  private String businessModel;

  /**
   * 电商平台
   */
  @ApiModelProperty("电商平台")
  private String commercePlatforms;

  /**
   * 电商客户等级
   */
  @ApiModelProperty("电商客户等级")
  private String commerceCustomerLevel;

  /**
   * 客户员工
   */
  @ApiModelProperty("客户员工")
  List<TerminalCustomerStaffVo> staff;

}
