package com.biz.crm.mdm.business.terminal.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @author ：dengwei
 * @date ：Created in 2023/1/16 22:01
 * @description：终端员工vo
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "终端员工vo")
public class TerminalEmployeeVo {

    @ApiModelProperty(name = "", notes = "门店编码")
    private String terminalCode;

    @ApiModelProperty("终端名称")
    private String terminalName;

    @ApiModelProperty(name = "", notes = "员工号")
    private String employeeCode;

    @ApiModelProperty(name = "", notes = "业态编码")
    private String orgCode;

    @ApiModelProperty(name = "", notes = "请求来源")
    private String source;

    @ApiModelProperty(name = "", notes = "角色编码")
    private String roleCode;

    @ApiModelProperty(name = "", notes = "外部智网编码")
    private String outZwCode;

    @ApiModelProperty(name = "", notes = "外部智网用户类型")
    private String outZwType;

    @ApiModelProperty(name = "", notes = "用户账号")
    private String account;

    @ApiModelProperty(name = "", notes = "手机号")
    private String phone;

    @ApiModelProperty(name = "", notes = "用户姓名")
    private String name;

    @ApiModelProperty(name = "", notes = "身份证号")
    private String identityCard;

    @ApiModelProperty(name = "", notes = "密码")
    private String password;

    @ApiModelProperty(name = "", notes = "有效开始时间")
    private String validStartDate;

    @ApiModelProperty(name = "", notes = "有效结束时间")
    private String validEndDate;

    @ApiModelProperty(name = "", notes = "用户状态:1:启用，2:禁用 默认:启用")
    private Integer status;

    @ApiModelProperty(name = "", notes = "认证状态:1:已认证，0:未认证 默认:未认证")
    private Integer authStatus;

    @ApiModelProperty(name = "", notes = "上级人员编码")
    private String parentEmployeeCode;

    @ApiModelProperty(name = "", notes = "上级人员姓名")
    private String parentEmployeeName;

    @ApiModelProperty(name = "", notes = "客户(经销商)编码")
    private String customerCode;

    @ApiModelProperty(name = "", notes = "客户(经销商)名称")
    private String customerName;

    @ApiModelProperty(name = "", notes = "地理区域")
    private String areaCode;

    @ApiModelProperty(name = "", notes = "双中心创建人")
    private String creatorCode;

    @ApiModelProperty(name = "", notes = "双中心修改人")
    private String modifierCode;

    @ApiModelProperty(name = "", notes = "智网empId")
    private String outZwId;

    @ApiModelProperty(name = "", notes = "unionId")
    private String unionId;

    @ApiModelProperty(name = "", notes = "openId")
    private String openId;

    @ApiModelProperty(name = "", notes = "appId")
    private String appId;

    @ApiModelProperty(name = "", notes = "empId")
    private String empId;

    @ApiModelProperty(name = "", notes = "微信认证状态")
    private String wxAuthStatus;

    @ApiModelProperty(name = "", notes = "身份认证状态")
    private String identityAuthStatus;

    @ApiModelProperty(name = "", notes = "总认证状态")
    private String employeeStatus;


    @ApiModelProperty(name = "fourIdentityCard", notes = "身份证号后四位")
    private String fourIdentityCard;

    @ApiModelProperty(name = "customerUserCode", notes = "客户人员编码")
    private String customerUserCode;

    @ApiModelProperty(name = "outStoreDate", notes = "外部店仓时间")
    private String outStoreDate;

    @ApiModelProperty(name = "outCreateDate", notes = "外部创建时间")
    private String outCreateDate;

    @ApiModelProperty(name = "age", notes = "年龄（岁）")
    private String age;

    @ApiModelProperty(name = "inMengNiuDate", notes = "入蒙牛时间")
    private String inMengNiuDate;

    @ApiModelProperty(name = "inVerticalDate", notes = "入垂直时间")
    private String inVerticalDate;

    @ApiModelProperty(name = "regularDate", notes = "转正时间")
    private String regularDate;

    @ApiModelProperty(name = "quitDate", notes = "离职时间")
    private String quitDate;

    @ApiModelProperty(name = "regionCode", notes = "大区编码")
    private String regionCode;

    @ApiModelProperty(name = "regionName", notes = "大区名称")
    private String regionName;

    @ApiModelProperty(name = "provinceCode", notes = "省份编码")
    private String provinceCode;

    @ApiModelProperty(name = "provinceName", notes = "省份名称")
    private String provinceName;

    @ApiModelProperty(name = "cityCode", notes = "城市编码")
    private String cityCode;

    @ApiModelProperty(name = "cityName", notes = "城市名称")
    private String cityName;

    @ApiModelProperty(name = "cityLevel", notes = "城市级别[数据字典:]")
    private String cityLevel;

    @ApiModelProperty(name = "systemCode", notes = "系统编码")
    private String systemCode;

    @ApiModelProperty(name = "systemName", notes = "系统名称")
    private String systemName;

    @ApiModelProperty(name = "kadCode", notes = "KAD编码")
    private String kadCode;

    @ApiModelProperty(name = "firstChannelCode", notes = "一级渠道编码")
    private String firstChannelCode;

    @ApiModelProperty(name = "firstChannelName", notes = "一级渠道名称")
    private String firstChannelName;

    @ApiModelProperty(name = "secondChannelCode", notes = "二级渠道编码")
    private String secondChannelCode;

    @ApiModelProperty(name = "secondChannelName", notes = "二级渠道名称")
    private String secondChannelName;

    @ApiModelProperty(name = "responsibleSupervision", notes = "责任督导")
    private String responsibleSupervision;

    @ApiModelProperty(name = "responsibleBusiness", notes = "责任业务")
    private String responsibleBusiness;

    @ApiModelProperty(name = "identityCardFrontAddress", notes = "身份证正面图地址")
    private String identityCardFrontAddress;

    @ApiModelProperty(name = "identityCardBackAddress", notes = "身份证反面图地址")
    private String identityCardBackAddress;

    @ApiModelProperty(name = "userType", notes = "用户类型")
    private String userType;

    @ApiModelProperty(name = "businessFormatCode", notes = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;
}
