package com.biz.crm.mdm.business.terminal.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 门店登录账号Vo
 *
 * @author liajngxin
 * @since 2023/3/9
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TerminalSignAccountVo", description = "门店登录账号Vo")
public class TerminalSignAccountVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 4205385689704158668L;
  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 登录账号
   */
  @ApiModelProperty("登录账号")
  private String signAccount;

  /**
   * 账号姓名
   */
  @ApiModelProperty("账号姓名")
  private String signName;

  /**
   * 账号角色
   */
  @ApiModelProperty("账号角色")
  private String signRole;

  /**
   * 微信认证状态
   */
  @ApiModelProperty("微信认证状态")
  private String weChatVerifyStatus;

  /**
   * 微信UnionId
   */
  @ApiModelProperty("微信UnionId")
  private String weChatUnionId;
}
