package com.biz.crm.mdm.business.terminal.sdk.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.WorkflowFlagOpVo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Transient;

/**
 * 终端信息vo
 *
 * @author sunx
 * @since 2021-10-19 13:53:15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "终端信息Vo")
public class TerminalVo extends WorkflowFlagOpVo {
  private static final long serialVersionUID = 4156812499833240753L;

  @ApiModelProperty("高德地图ID")
  private String amapId;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  @ApiModelProperty("终端面积")
  private String terminalArea;

  /**
   * 是否直营
   */
  @ApiModelProperty("是否直营")
  private String directFlag;

  /**
   * 开店时间
   */
  @ApiModelProperty("开店时间")
  private String startShopTime;

  /**
   * 关店时间
   */
  @ApiModelProperty("关店时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private String closeShopTime;


  /**
   * 送达方编码
   */
  @ApiModelProperty("送达方编码")
  private String deliveryWayCode;

  /**
   * 送达方名称
   */
  @ApiModelProperty("送达方名称")
  private String deliveryWayName;


  /**
   * AC终端类型编码
   */
  @ApiModelProperty("AC终端类型编码")
  private String terminalTypeCode;

  /**
   * AC终端类型名称
   */
  @ApiModelProperty("AC终端类型名称")
  private String terminalTypeName;

  /**
   * 一级渠道编码
   */
  @ApiModelProperty("一级渠道编码")
  private String firstChannelCode;

  /**
   * 一级渠道名称
   */
  @ApiModelProperty("一级渠道名称")
  private String firstChannelName;

  /**
   * 二级渠道编码
   */
  @ApiModelProperty("二级渠道编码")
  private String secondChannelCode;

  /**
   * 二级渠道名称
   */
  @ApiModelProperty("二级渠道名称")
  private String secondChannelName;


  /**
   * 售达方编码
   */
  @ApiModelProperty("售达方编码")
  private String sellerCode;

  /**
   * 售达方名称
   */
  @ApiModelProperty("售达方名称")
  private String sellerName;

  /**
   * 渠道
   */
  @ApiModelProperty("渠道")
  private String channel;

  /**
   * 营业执照人名称
   */
  @ApiModelProperty("营业执照人名称")
  private String licensePersonName;

  /**
   * 营业执照注册号
   */
  @ApiModelProperty("营业执照注册号")
  private String licenseRegisterNumber;

  /**
   * 营业执照企业名称
   */
  @ApiModelProperty("营业执照企业名称")
  private String licenseFirmName;

  /**
   * 终端地址
   */
  @ApiModelProperty("终端地址")
  private String terminalAddress;

  @ApiModelProperty("所属销售机构编码")
  private String salesInstitutionCode;

  @ApiModelProperty("所属销售机构")
  private String salesInstitutionName;

  @ApiModelProperty("所属销售大区编码")
  private String salesRegionCode;

  @ApiModelProperty("所属销售大区编码")
  private String salesRegionName;

  @ApiModelProperty("所属销售组织(组)编码")
  private String salesOrgCode;


  @ApiModelProperty("所属销售组织(组)名称")
  private String salesOrgName;

  /**
   * 省
   */
  @ApiModelProperty("省")
  private String provinceCode;

  @ApiModelProperty("省名称")
  private String provinceName;

  /**
   * 市
   */
  @ApiModelProperty("市")
  private String cityCode;

  @ApiModelProperty("市名称")
  private String cityName;

  /**
   * 区
   */
  @ApiModelProperty("区")
  private String districtCode;

  @ApiModelProperty("区名称")
  private String districtName;

  /**
   * 乡镇/街道
   */
  @ApiModelProperty("乡镇/街道")
  private String townshipCode;

  /**
   * 乡镇/街道
   */
  @ApiModelProperty(" 乡镇/街道")
  private String townshipName;

  /**
   * 村/社区
   */
  @ApiModelProperty("村/社区")
  private String communityCode;

  /**
   * 村/社区
   */
  @ApiModelProperty(" 村/社区")
  private String communityName;

  /**
   * 店招照片
   */
  @ApiModelProperty("店招照片")
  private String shopImagePath;

  /**
   * 营业执照照片
   */
  @ApiModelProperty("营业执照照片")
  private String licenseImagePath;

  /**
   * 社会信用代码
   */
  @ApiModelProperty("社会信用代码")
  private String licenseCreditCode;

  /**
   * 营业执照认证状态
   */
  @ApiModelProperty("营业执照认证状态")
  private String licenseVerifyStatus;

  /**
   * 营业执照认证时间
   */
  @ApiModelProperty("营业执照认证时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date licenseVerifyTime;

  /**
   * 经度
   */
  @ApiModelProperty("经度")
  private BigDecimal longitude;

  /**
   * 纬度
   */
  @ApiModelProperty("纬度")
  private BigDecimal latitude;

  /**
   * 客户分类
   */
  @ApiModelProperty("客户分类")
  private String customerClassification;

  /**
   * 审批状态,枚举MdmBpmStatusEnum
   */
  @ApiModelProperty(
          "审批状态,枚举TerminalActApproveStatusEnum"
                  + "  SUBMIT(\"1\", \"待提交\"),\n"
                  + "  APPROVAL(\"2\", \"审批中\"),\n"
                  + "  PASS(\"3\", \"通过\"),\n"
                  + "  REJECT(\"4\", \"驳回\"),\n"
                  + "  RECOVER(\"5\", \"追回\"),\n"
                  + "  CLOSE(\"6\", \"关闭\")")
  private String actApproveStatus;

  /**
   * 合作状态
   */
  @ApiModelProperty("合作状态")
  private String cooperateStatus;

  /**
   * kms客户关联门店id
   */
  @ApiModelProperty("kms客户关联门店id")
  private String storeId;

  /**
   * kms直营体系id
   */
  @ApiModelProperty("kms直营体系id")
  private String directSystemId;

  /**
   * kms售达方id
   */
  @ApiModelProperty("kms售达方id")
  private String sellPartyId;

  @ApiModelProperty("审批类型")
  private String approvalType;

  @ApiModelProperty("流程实例编码")
  private String processCode;

  /**
   * 数据来源
   */
  @ApiModelProperty("数据来源")
  private String sourceType;

  /**
   * 业务来源系统
   */
  @ApiModelProperty("业务来源系统")
  private String fromType;

  /**
   * 分仓名称
   */
  @ApiModelProperty("分仓名称")
  private String pointsWarehouseName;

  /**
   * 分仓编码
   */
  @ApiModelProperty("分仓编码")
  private String pointsWarehouseCode;

  /**
   * 城市级别编码
   */
  @ApiModelProperty("城市级别编码")
  private String districtLevelCode;

  /**
   * 城市级别名称
   */
  @ApiModelProperty("城市级别名称")
  private String districtLevelName;

  /**
   * 零售商编码
   */
  @ApiModelProperty("零售商编码")
  private String customerRetailerCode;

  /**
   * 零售商
   */
  @ApiModelProperty("零售商")
  private String customerRetailerName;


  @ApiModelProperty("终端关联组织集合")
  private List<TerminalRelaOrgVo> orgList;

  /**
   * 店主姓名
   */
  @ApiModelProperty("店主姓名")
  private String masterName;

  /**
   * 店主电话
   */
  @ApiModelProperty("店主电话")
  private String masterPhone;

  @ApiModelProperty("店主座机")
  private String masterLandline;

  /**
   * 店主身份证号
   */
  @ApiModelProperty("店主身份证号")
  private String masterIdNumber;

  @ApiModelProperty("店主实人认证状态")
  private String masterVerifyStatus;

  /**
   * 店主实人认证时间
   */
  @ApiModelProperty("店主实人认证时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date masterVerifyTime;

  @ApiModelProperty("店主微信unionID")
  private String masterWeChatUnionId;

  @ApiModelProperty("店主微信认证状态")
  private String masterWeChatVerifyStatus;

  /**
   * 微信认证时间
   */
  @ApiModelProperty("店主微信认证时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date masterWeChatVerifyTime;

  /**
   * 区域
   */
  @ApiModelProperty("区域")
  private String regionName;

  /**
   * 区域编码
   */
  @ApiModelProperty("区域编码")
  private String regionCode;
  /**
   * 组织名字逗号隔开
   */
  @ApiModelProperty("组织名字逗号隔开")
  private String orgNameStr;

  @ApiModelProperty("终端关联客户组织集合")
  private List<TerminalRelaCustomerOrgVo> customerOrgList;

  @ApiModelProperty("终端关联客户集合")
  private List<TerminalCustomerVo> customerList;

  @ApiModelProperty("联系人/店主信息集合")
  private List<TerminalContactVo> contacts;

  @ApiModelProperty("供货关系集合")
  private List<TerminalSupplyVo> supplys;

  @ApiModelProperty("登陆账号")
  private List<TerminalSignAccountVo> terminalSignAccountList;

  /**
   * 业态名称
   */
  @ApiModelProperty(name = "业态名称")
  private String businessFormatName;


  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  private String terminalType;

  @ApiModelProperty("终端状态")
  private String terminalState;

  @ApiModelProperty("存续状态")
  private String survivalState;

  /**
   * 是否送达方
   */
  @ApiModelProperty("是否送达方")
  private String settleDestination;

  @ApiModelProperty("poi分类编码")
  private String amapPoiTypeCode;

  @ApiModelProperty("poi分类名称")
  private String amapPoiTypeName;

  @ApiModelProperty("售点周边编码")
  private String amapMerchCode;

  @ApiModelProperty("售点周边名称")
  private String amapMerchName;

  @ApiModelProperty("城市等级")
  @Column(
          name = "amap_city_level",
          nullable = false,
          unique = true,
          length = 16,
          columnDefinition = "VARCHAR(16) COMMENT '城市等级'")
  private String amapCityLevel;

  @ApiModelProperty("地图认证状态")
  private String amapVerifyStatus;

  /**
   * 地图认证时间
   */
  @ApiModelProperty("地图认证时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date amapVerifyTime;

  /**
   * 终端编码加名称拼接
   */
  @ApiModelProperty("终端编码加名称拼接")
  private String terminalCodeAndName;

  /**
   * 距离
   */
  @ApiModelProperty("距离(米)")
  private Integer distance;



  @ApiModelProperty("所属销售部门(TPM)erp编码")
  private String salesDepartTpmErpCode;

  @ApiModelProperty("所属销售部门(TPM)编码")
  private String salesDepartTpmCode;

  @ApiModelProperty("所属销售部门(TPM)名称")
  private String salesDepartTpmName;


  @ApiModelProperty("所属销售区域erp编码")
  private String salesDistrictErpCode;

  @ApiModelProperty("所属销售区域编码")
  private String salesDistrictCode;

  @ApiModelProperty("所属销售区域名称")
  private String salesDistrictName;
}
