package com.biz.crm.mdm.business.terminal.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 终端客户信息dto
 *
 * @author songjingen
 */
@EqualsAndHashCode(callSuper = false)
@Data
@ApiModel(value = "TerminalClientDto", description = "终端客户信息dto")
public class TerminalClientDto {

  private static final long serialVersionUID = 5323221664981825624L;

  /**
   * 企业用户账号
   */
  @ApiModelProperty(value = "企业用户账号", required = true)
  private String userName;

  /**
   * 租户编码
   */
  @ApiModelProperty(value = "租户编码", required = true)
  private String tenantCode;

  /**
   * 终端编码
   */
  @ApiModelProperty(value = "终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty(value = "终端名称")
  private String terminalName;

  /**
   * 关键字
   */
  @ApiModelProperty("关键字（客户 编码）")
  private String keyWord;

  /**
   * 审批状态
   */
  @ApiModelProperty("审批状态")
  private String processStatus;

  /**
   * 终端类型
   */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /**
   * 所有下级岗位编码集合(包含自身)
   */
  private List<String> AllChildrenPostCodes;

  /**
   * 终端编码
   */
  private List<String> terminalCodes;

}