package com.biz.crm.mdm.business.terminal.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.mdm.business.customer.sdk.dto.SupplyRelationshipDto;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalPersonVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.vo.AttachmentVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 终端信息dto
 *
 * @author sunx
 * @since 2021-10-19 13:53:13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TerminalDto", description = "终端信息dto")
public class TerminalDto extends TenantFlagOpDto {

  /**
   * 工作流参数
   */
  @ApiModelProperty("工作流参数")
  private ProcessBusinessDto processBusiness;

  @ApiModelProperty("高德地图ID")
  private String amapId;

  /** 终端编码 */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /** 终端名称 */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /** 终端类型 */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /** 渠道 */
  @ApiModelProperty("渠道")
  private String channel;

  /** 营业执照人名称 */
  @ApiModelProperty("营业执照人名称")
  private String licensePersonName;

  /** 营业执照注册号 */
  @ApiModelProperty("营业执照注册号")
  private String licenseRegisterNumber;

  /** 营业执照企业名称 */
  @ApiModelProperty("营业执照企业名称")
  private String licenseFirmName;

  /** 终端地址 */
  @ApiModelProperty("终端地址")
  private String terminalAddress;

  /** 省 */
  @ApiModelProperty("省")
  private String provinceCode;

  @ApiModelProperty("省名称")
  private String provinceName;

  /** 市 */
  @ApiModelProperty("市")
  private String cityCode;

  @ApiModelProperty("市名称")
  private String cityName;

  /** 区 */
  @ApiModelProperty("区")
  private String districtCode;

  @ApiModelProperty("区名称")
  private String districtName;

  /** 店招照片 */
  @ApiModelProperty("店招照片")
  private String shopImagePath;

  /** 营业执照照片 */
  @ApiModelProperty("营业执照照片")
  private String licenseImagePath;

  /** 经度 */
  @ApiModelProperty("经度")
  private BigDecimal longitude;

  /** 纬度 */
  @ApiModelProperty("纬度")
  private BigDecimal latitude;

  /** 客户分类 */
  @ApiModelProperty("客户分类")
  private String customerClassification;

  /** 审批状态,枚举MdmBpmStatusEnum */
  @ApiModelProperty(
      "审批状态,枚举TerminalActApproveStatusEnum"
          + "  SUBMIT(\"1\", \"待提交\"),\n"
          + "  APPROVAL(\"2\", \"审批中\"),\n"
          + "  PASS(\"3\", \"通过\"),\n"
          + "  REJECT(\"4\", \"驳回\"),\n"
          + "  RECOVER(\"5\", \"追回\"),\n"
          + "  CLOSE(\"6\", \"关闭\")")
  private String actApproveStatus;

  /** 合作状态 */
  @ApiModelProperty("合作状态")
  private String cooperateStatus;

  /** kms客户关联门店id */
  @ApiModelProperty("kms客户关联门店id")
  private String storeId;

  /** kms直营体系id */
  @ApiModelProperty("kms直营体系id")
  private String directSystemId;

  /** kms售达方id */
  @ApiModelProperty("kms售达方id")
  private String sellPartyId;

  @ApiModelProperty("审批类型")
  private String approvalType;

  @ApiModelProperty("流程实例编码")
  private String processCode;

  /** 数据来源 */
  @ApiModelProperty("数据来源")
  private String sourceType;

  /** 业务来源系统 */
  @ApiModelProperty("业务来源系统")
  private String fromType;

  /** 是否分利 true/false */
  @ApiModelProperty("是否分利")
  private Boolean shareBenefits;

  @ApiModelProperty(value = "终端id（EAS）")
  private String sourcesId;

  @ApiModelProperty(value = "终端id（兆信）")
  private String terminalId;


  @ApiModelProperty(value = "终端渠道分类id")
  private String terminalClassifyId;


  @ApiModelProperty(value = "终端渠道分类名称")
  private String terminalClassifyName;

  @ApiModelProperty(value = "终端渠道等级id")
  private String terminalLevelId;

  @ApiModelProperty(value = "终端渠道等级名称")
  private String terminalLevelName;

  @ApiModelProperty(value = "联系人")
  private String contactName;

  @ApiModelProperty(value = "手机号")
  private String phone;

  @ApiModelProperty("身份证号")
  private String idNum;

  @ApiModelProperty("身份证正面图片")
  private String idCardFrontPicURL;

  @ApiModelProperty("身份证反面图片")
  private String idCardBehindPicURL;

  @ApiModelProperty("街道编码")
  private String townCode;

  @ApiModelProperty("街道名称")
  private String townName;

  @ApiModelProperty("邮箱")
  private String email;

  @ApiModelProperty("邮政编码")
  private String postalCode;

  @ApiModelProperty("认证状态")
  private String certificationStatus;

  @ApiModelProperty("采供关系")
  private String supplyRelationship;

  @ApiModelProperty(value ="渠道类型")
  private String channelType;

  @ApiModelProperty(value ="渠道类型名称")
  private String channelTypeName;

  @ApiModelProperty(value ="渠道分类")
  private String channelCategory;

  @ApiModelProperty(value ="渠道等级")
  private String channelLevelCode;

  @ApiModelProperty("合作状态")
  private String cooperationStatus;

  /** 终端编码集合 */
  @ApiModelProperty("终端编码集合")
  private List<String> terminalCodeList;

  @ApiModelProperty("终端关联组织集合")
  private List<TerminalRelaOrgDto> orgList;

  @ApiModelProperty("终端关联客户组织集合")
  private List<TerminalRelaCustomerOrgDto> customerOrgList;

  @ApiModelProperty("联系人信息集合")
  private List<TerminalContactDto> contacts;

  @ApiModelProperty("供货关系集合")
  private List<TerminalSupplyDto> supplys;

  @ApiModelProperty("供货关系集合")
  private List<SupplyRelationshipDto> relationshipList;

  /**
   * 流程附件信息
   */
  @ApiModelProperty(value = "流程附件信息")
  private List<AttachmentVo> attachmentVos;

  @ApiModelProperty("终端业务员集合")
  private List<TerminalPersonVo> personVos;
}
