package com.biz.crm.mdm.business.terminal.sdk.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author: yangshen
 * @DATE: 2023/5/15 14:25
 * @NAME: TerminalLugAndLatQueryDto
 * @PACKAGE_NAME: com.biz.crm.mdm.business.terminal.sdk.dto
 * @Version 1.0
 * @Description 终端经纬度查询dto
 */
@Data
public class TerminalLugAndLatQueryDto {

  /**
   * 纬度底
   */
  @ApiModelProperty("纬度底")
  private Double minLat;

  /**
   * 纬度顶
   */
  @ApiModelProperty("纬度顶")
  private Double maxLat;

  /**
   * 经度底
   */
  @ApiModelProperty("经度底")
  private Double minLng;

  /**
   * 经度顶
   */
  @ApiModelProperty("经度顶")
  private Double maxLng;

  //以上是mybatis查询的时候使用的 ----- 以下是接口调用时传入的参数

  /**
   * 当前所在城市
   */
  @ApiModelProperty("当前所在城市")
  private String cityCode;

  /**
   * 当前位置经度
   */
  @ApiModelProperty("当前位置经度")
  private String currentLng;

  /**
   * 当前位置纬度
   */
  @ApiModelProperty("当前位置纬度")
  private String currentLat;

  /**
   * 距离（单位km）
   */
  @ApiModelProperty("距离（单位km）")
  private String distance;
}
