package com.biz.crm.mdm.business.terminal.sdk.dto;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import lombok.Data;

import java.util.Set;

/**
 * 根据TerminalQueryDto获取匹配的终端编码
 *
 * @author sunx
 * @date 2022/5/27
 */
@Data
public class TerminalQueryDto {
  /** 终端编码模糊查询 */
  private String terminalCode;
  /** 终端名称模糊查询 */
  private String terminalName;
  /** 渠道编码 */
  private String channel;
  /** 组织名称模糊查询 */
  private String orgName;
  /** 删除标记 */
  private String delFlag = DelFlagStatusEnum.NORMAL.getCode();
  /** 审核状态 */
  private String processStatus = ProcessStatusEnum.PASS.getDictCode();
  /** 终端编码集合查询 */
  private Set<String> terminalCodeSet;
  /** 组织编码集合 */
  private Set<String> orgCodeSet;
}
