package com.biz.crm.mdm.business.terminal.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 终端与组织关联表dto
 *
 * @author sunx
 * @since 2021-10-19 13:54:14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TerminalROrgDto", description = "终端与组织关联表dto")
public class TerminalRelaOrgDto extends TenantDto {

  /** 终端编码 */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /** 组织编码 */
  @ApiModelProperty("组织编码")
  private String orgCode;

  /** 组织名称 */
  @ApiModelProperty("组织名称")
  private String orgName;
  @ApiModelProperty(value = "终端名称")
  private String terminalName;

  @ApiModelProperty(value = "终端id（EAS）")
  private String sourcesId;

  @ApiModelProperty(value = "终端id（兆信）")
  private String terminalId;

  @ApiModelProperty(value = "关联组织id（EAS）")
  private String sourcesOrgId;

  @ApiModelProperty(value = "状态")
  private String status;

  @ApiModelProperty(value = "操作")
  private String opt;


  @ApiModelProperty("数据状态（删除状态）")
  private String delFlag;


  @ApiModelProperty("数据业务状态（启用状态）")
  private String enableStatus;

  @ApiModelProperty("备注")
  private String remark;
}
