package com.biz.crm.mdm.business.terminal.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 职位分页ex返回vo
 *
 * @author sunx
 * @date 2022/3/17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位分页ex返回vo")
public class SupplyPositionPageVo {
  /** 职位编码 */
  @ApiModelProperty("职位编码")
  private String positionCode;
  /** 职位名称 */
  @ApiModelProperty("职位名称")
  private String positionName;
  /** 关联组织编码 */
  @ApiModelProperty("关联组织编码")
  private String orgCode;
  /** 关联组织名称 */
  @ApiModelProperty("关联组织名称")
  private String orgName;
  /** 职位级别编码 */
  @ApiModelProperty("职位级别编码")
  private String positionLevelCode;
  /** 职位级别名称 */
  @ApiModelProperty("职位级别名称")
  private String positionLevelName;
  /** 是否主职位(true:是,false:否) */
  @ApiModelProperty("是否主职位(true:是,false:否)")
  private Boolean primaryFlag;
  /** 用户登录名 */
  @ApiModelProperty("用户登录名")
  private String userName;
  /** 用户姓名 */
  @ApiModelProperty("用户姓名")
  private String fullName;
  /** 用户编码 */
  @ApiModelProperty("用户编码")
  private String userCode;
  /** 用户电话 */
  @ApiModelProperty("用户电话")
  private String userPhone;
  /** 上级职位编码 */
  @ApiModelProperty("上级职位编码")
  private String parentCode;
  /** 上级职位名称 */
  @ApiModelProperty("上级职位名称")
  private String parentName;
  /** 上级组织编码 */
  @ApiModelProperty("上级组织编码")
  private String parentOrgCode;
  /** 上级组织名称 */
  @ApiModelProperty("上级组织名称")
  private String parentOrgName;
  /** 角色编码，多个用英文逗号隔开 */
  @ApiModelProperty("角色编码，多个用英文逗号隔开")
  private String roleCode;
  /** 角色名称，多个用英文逗号隔开 */
  @ApiModelProperty("角色名称，多个用英文逗号隔开")
  private String roleName;
  /** 组织名称/职位名称/用户名称 */
  @ApiModelProperty("组织名称/职位名称/用户名称")
  private String unionName;

  /** 上级用户登录名 */
  @ApiModelProperty("上级用户登录名")
  private String parentUserName;
  /** 上级用户姓名 */
  @ApiModelProperty("上级用户姓名")
  private String parentFullName;
}
