package com.biz.crm.mdm.business.terminal.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.vo.WorkflowFlagOpVo;
import com.biz.crm.mdm.business.customer.sdk.vo.SupplyRelationshipVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 终端信息vo
 *
 * @author sunx
 * @since 2021-10-19 13:53:15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "终端信息Vo")
public class TerminalVo extends WorkflowFlagOpVo {
  private static final long serialVersionUID = 4156812499833240753L;

  @ApiModelProperty("高德地图ID")
  private String amapId;

  /** 终端编码 */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /** 终端名称 */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /** 终端类型 */
  @ApiModelProperty("终端类型")
  private String terminalType;

  /** 渠道 */
  @ApiModelProperty("渠道")
  private String channel;

  /** 营业执照人名称 */
  @ApiModelProperty("营业执照人名称")
  private String licensePersonName;

  /** 营业执照注册号 */
  @ApiModelProperty("营业执照注册号")
  private String licenseRegisterNumber;

  /** 营业执照企业名称 */
  @ApiModelProperty("营业执照企业名称")
  private String licenseFirmName;

  /** 终端地址 */
  @ApiModelProperty("终端地址")
  private String terminalAddress;

  /** 省 */
  @ApiModelProperty("省")
  private String provinceCode;

  @ApiModelProperty("省名称")
  private String provinceName;

  /** 市 */
  @ApiModelProperty("市")
  private String cityCode;

  @ApiModelProperty("市名称")
  private String cityName;

  /** 区 */
  @ApiModelProperty("区")
  private String districtCode;

  @ApiModelProperty("区名称")
  private String districtName;

  /** 店招照片 */
  @ApiModelProperty("店招照片")
  private String shopImagePath;

  /** 营业执照照片 */
  @ApiModelProperty("营业执照照片")
  private String licenseImagePath;

  /** 经度 */
  @ApiModelProperty("经度")
  private BigDecimal longitude;

  /** 纬度 */
  @ApiModelProperty("纬度")
  private BigDecimal latitude;

  /** 客户分类 */
  @ApiModelProperty("客户分类")
  private String customerClassification;

  /** 审批状态,枚举MdmBpmStatusEnum */
  @ApiModelProperty(
      "审批状态,枚举TerminalActApproveStatusEnum"
          + "  SUBMIT(\"1\", \"待提交\"),\n"
          + "  APPROVAL(\"2\", \"审批中\"),\n"
          + "  PASS(\"3\", \"通过\"),\n"
          + "  REJECT(\"4\", \"驳回\"),\n"
          + "  RECOVER(\"5\", \"追回\"),\n"
          + "  CLOSE(\"6\", \"关闭\")")
  private String actApproveStatus;

  /** 合作状态 */
  @ApiModelProperty("合作状态")
  private String cooperateStatus;

  /** kms客户关联门店id */
  @ApiModelProperty("kms客户关联门店id")
  private String storeId;

  /** kms直营体系id */
  @ApiModelProperty("kms直营体系id")
  private String directSystemId;

  /** kms售达方id */
  @ApiModelProperty("kms售达方id")
  private String sellPartyId;

  @ApiModelProperty("审批类型")
  private String approvalType;

  @ApiModelProperty("流程实例编码")
  private String processCode;

  /** 数据来源 */
  @ApiModelProperty("数据来源")
  private String sourceType;

  /** 业务来源系统 */
  @ApiModelProperty("业务来源系统")
  private String fromType;

  /**
   * 是否分利 true/false
   * 可能为空，为空则默认为false
   */
  @ApiModelProperty("是否分利")
  private Boolean shareBenefits;

  /**
   * 设置为分利终端时间
   */
  @ApiModelProperty("设置为分利终端时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  private Date shareBenefitsTime;


  @ApiModelProperty("终端关联组织集合")
  private List<TerminalRelaOrgVo> orgList;

  /**
   * 组织名字逗号隔开
   */
  @ApiModelProperty("组织名字逗号隔开")
  private String orgNameStr;

  @ApiModelProperty("终端关联客户组织集合")
  private List<TerminalRelaCustomerOrgVo> customerOrgList;

  @ApiModelProperty("联系人信息集合")
  private List<TerminalContactVo> contacts;

  @ApiModelProperty("供货关系集合")
  private List<TerminalSupplyVo> supplys;

  @ApiModelProperty("标签集合")
  private List<TerminalTagVo> tagVos;

  @ApiModelProperty("终端业务员集合")
  private List<TerminalPersonVo> personVos;

  @ApiModelProperty("采供关系集合")
  private List<SupplyRelationshipVo> relationshipList;

  /**
   * 相隔的距离 四舍五入后的 单位M
   */
  @ApiModelProperty("距离当前位置的距离 四舍五入后的(单位M)")
  private Long distanceBetween;

  @ApiModelProperty(value = "终端id（EAS）")
  private String sourcesId;

  @ApiModelProperty(value = "终端id（兆信）")
  private String terminalId;


  @ApiModelProperty(value = "终端渠道分类id")
  private String terminalClassifyId;


  @ApiModelProperty(value = "终端渠道分类名称")
  private String terminalClassifyName;

  @ApiModelProperty(value = "终端渠道等级id")
  private String terminalLevelId;

  @ApiModelProperty(value = "终端渠道等级名称")
  private String terminalLevelName;

  @ApiModelProperty(value = "联系人")
  private String contactName;

  @ApiModelProperty(value = "手机号")
  private String phone;

  @ApiModelProperty("身份证号")
  private String idNum;

  @ApiModelProperty("身份证正面图片")
  private String idCardFrontPicURL;

  @ApiModelProperty("身份证反面图片")
  private String idCardBehindPicURL;

  @ApiModelProperty("街道编码")
  private String townCode;

  @ApiModelProperty("街道名称")
  private String townName;

  @ApiModelProperty("邮箱")
  private String email;

  @ApiModelProperty("邮政编码")
  private String postalCode;

  @ApiModelProperty("认证状态")
  private String certificationStatus;

  @ApiModelProperty("采供关系")
  private String supplyRelationship;

  @ApiModelProperty("用户与终端之间的距离")
  private double distance;

  @ApiModelProperty(value ="渠道类型")
  private String channelType;

  @ApiModelProperty(value ="渠道分类")
  private String channelCategory;

  @ApiModelProperty(value ="渠道等级")
  private String channelLevelCode;

  @ApiModelProperty("合作状态")
  private String cooperationStatus;

  @ApiModelProperty("渠道类型名称")
  private String channelTypeName;

}
