package com.biz.crm.mdm.business.terminal.user.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.user.feign.feign.TerminalUserVoFeign;
import com.biz.crm.mdm.business.terminal.user.sdk.vo.TerminalUserVo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 终端用户feign接口熔断类
 *
 * @author ning.zhang
 * @date 2022/2/22
 */
@Slf4j
@Component
public class TerminalUserVoFeignImpl implements FallbackFactory<TerminalUserVoFeign> {
  @Override
  public TerminalUserVoFeign create(Throwable throwable) {
    return new TerminalUserVoFeign() {
      @Override
      public Result<TerminalUserVo> findByUserPhone(String userPhone) {
        throw new UnsupportedOperationException("通过用户手机号获取终端用户信息熔断");
      }

      @Override
      public Result<java.util.List<TerminalUserVo>> findDetailsByUserCodes(java.util.List<String> userCodes) {
        throw new UnsupportedOperationException("通过用户编码集合获取终端用户信息熔断");
      }
    };
  }
}
