package com.biz.crm.mdm.business.terminal.user.feign.service.internal;

import com.biz.crm.mdm.business.terminal.user.feign.feign.TerminalUserVoFeign;
import com.biz.crm.mdm.business.terminal.user.sdk.dto.TerminalUserDto;
import com.biz.crm.mdm.business.terminal.user.sdk.service.TerminalUserVoService;
import com.biz.crm.mdm.business.terminal.user.sdk.vo.TerminalUserVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 终端用户Vo接口实现类
 *
 * @author ning.zhang
 * @date 2022/2/22
 */
@Service("FeignTerminalUserVoServiceImpl")
public class TerminalUserVoServiceImpl implements TerminalUserVoService {

  @Autowired(required = false)
  private TerminalUserVoFeign terminalUserVoFeign;

  @Override
  public List<TerminalUserVo> findDetailsByIdsOrUserCodes(List<String> ids, List<String> userCodes) {
    return this.terminalUserVoFeign.findDetailsByUserCodes(userCodes).checkFeignResult();
  }

  @Override
  public TerminalUserVo create(TerminalUserDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public TerminalUserVo update(TerminalUserDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public TerminalUserVo findByUserPhone(String userPhone) {
    return this.terminalUserVoFeign.findByUserPhone(userPhone).checkFeignResult();
  }
}
