package com.biz.crm.mdm.business.terminal.user.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.terminal.user.local.entity.TerminalUser;
import com.biz.crm.mdm.business.terminal.user.sdk.dto.TerminalUserPaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 终端用户(TerminalUser)表数据库访问层
 *
 * @author sunx
 * @since 2021-10-20 16:35:03
 */
public interface TerminalUserMapper extends BaseMapper<TerminalUser> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto 分页参数dto
   * @return 分页列表
   */
  Page<TerminalUser> findByConditions(
      Page<TerminalUser> page, @Param("dto") TerminalUserPaginationDto dto);
}
