/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.user.local.service.internal;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mdm.business.terminal.user.local.entity.TerminalUser;
import com.biz.crm.mdm.business.terminal.user.local.entity.TerminalUserRelaTerminal;
import com.biz.crm.mdm.business.terminal.user.local.repository.TerminalUserRepository;
import com.biz.crm.mdm.business.terminal.user.local.service.TerminalUserRelaTerminalService;
import com.biz.crm.mdm.business.terminal.user.local.service.TerminalUserService;
import com.biz.crm.mdm.business.terminal.user.sdk.dto.TerminalUserDto;
import com.biz.crm.mdm.business.terminal.user.sdk.dto.TerminalUserRelaTerminalDto;
import com.biz.crm.mdm.business.terminal.user.sdk.event.TerminalUserEventListener;
import com.biz.crm.mdm.business.terminal.user.sdk.service.TerminalUserVoService;
import com.biz.crm.mdm.business.terminal.user.sdk.vo.TerminalUserRelaTerminalVo;
import com.biz.crm.mdm.business.terminal.user.sdk.vo.TerminalUserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TerminalUserVoServiceImpl
implements TerminalUserVoService {
    @Autowired(required=false)
    private TerminalUserService terminalUserService;
    @Autowired(required=false)
    private TerminalUserRelaTerminalService terminalUserRelaTerminalService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<TerminalUserEventListener> eventListeners;
    @Autowired(required=false)
    private TerminalUserRepository terminalUserRepository;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;

    public List<TerminalUserVo> findDetailsByIdsOrUserCodes(List<String> ids, List<String> userCodes) {
        List<Object> re = Lists.newLinkedList();
        if (CollectionUtils.isEmpty(ids) && CollectionUtils.isEmpty(userCodes)) {
            return re;
        }
        List<TerminalUser> terminalUserList = this.terminalUserService.findDetailsByIdsOrUserCodes(ids, userCodes);
        if (CollectionUtils.isEmpty(terminalUserList)) {
            return re;
        }
        List<String> userCodeList = terminalUserList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getUserCode())).map(TerminalUser::getUserCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userCodeList)) {
            return re;
        }
        List<TerminalUserRelaTerminal> terminalList = this.terminalUserRelaTerminalService.findByUserCodes(userCodeList);
        re = this.buildTerminalUserVoList(terminalUserList, terminalList);
        return re;
    }

    @Transactional
    public TerminalUserVo create(TerminalUserDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        TerminalUser terminalUser = (TerminalUser)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TerminalUser.class, HashSet.class, ArrayList.class, new String[0]));
        dto.setLockState(Optional.ofNullable(dto.getLockState()).orElse(EnableStatusEnum.ENABLE.getCode()));
        this.terminalUserService.create(terminalUser);
        dto.setUserCode(terminalUser.getUserCode());
        this.bindExtInfo(dto);
        TerminalUserVo re = this.buildByDtoAndTerminalUser(dto, terminalUser);
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return re;
        }
        for (TerminalUserEventListener eventListener : this.eventListeners) {
            eventListener.onCreate(re);
        }
        return re;
    }

    @Transactional
    public TerminalUserVo update(TerminalUserDto dto) {
        List<TerminalUserVo> list;
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        dto.setLockState(Optional.ofNullable(dto.getLockState()).orElse(EnableStatusEnum.ENABLE.getCode()));
        Boolean flag = CollectionUtils.isNotEmpty(this.eventListeners);
        TerminalUserVo oldVo = null;
        if (Boolean.TRUE.equals(flag) && CollectionUtils.isNotEmpty(list = this.findDetailsByIdsOrUserCodes(Lists.newArrayList((Object[])new String[]{dto.getId()}), null))) {
            oldVo = list.get(0);
        }
        TerminalUser terminalUser = (TerminalUser)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TerminalUser.class, HashSet.class, ArrayList.class, new String[0]));
        this.terminalUserService.update(terminalUser);
        dto.setUserCode(terminalUser.getUserCode());
        this.bindExtInfo(dto);
        TerminalUserVo re = this.buildByDtoAndTerminalUser(dto, terminalUser);
        if (Boolean.FALSE.equals(flag)) {
            return re;
        }
        for (TerminalUserEventListener eventListener : this.eventListeners) {
            eventListener.onUpdate(oldVo, re);
        }
        return re;
    }

    public TerminalUserVo findByUserPhone(String userPhone) {
        Validate.notBlank((CharSequence)userPhone, (String)"\u624b\u673a\u53f7\u7f3a\u5931", (Object[])new Object[0]);
        TerminalUser terminalUser = this.terminalUserRepository.findUserByPhone(userPhone);
        if (Objects.isNull((Object)terminalUser)) {
            return null;
        }
        List<TerminalUserRelaTerminal> terminalList = this.terminalUserRelaTerminalService.findByUserCodes(Lists.newArrayList((Object[])new String[]{terminalUser.getUserCode()}));
        List<TerminalUserVo> list = this.buildTerminalUserVoList(Lists.newArrayList((Object[])new TerminalUser[]{terminalUser}), terminalList);
        return list.get(0);
    }

    @Transactional
    public void bindExtInfo(TerminalUserDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        List terminalList = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getTerminalList())) {
            for (TerminalUserRelaTerminalDto item : dto.getTerminalList()) {
                item.setUserCode(dto.getUserCode());
            }
            terminalList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getTerminalList(), TerminalUserRelaTerminalDto.class, TerminalUserRelaTerminal.class, HashSet.class, ArrayList.class, new String[0]);
            terminalList.forEach(a -> a.setUserCode(dto.getUserCode()));
        }
        this.terminalUserRelaTerminalService.saveBatch(terminalList, dto.getUserCode());
    }

    private List<TerminalUserVo> buildTerminalUserVoList(List<TerminalUser> terminalUserList, List<TerminalUserRelaTerminal> terminalList) {
        List<TerminalUserVo> re = Lists.newLinkedList();
        Map<Object, Object> map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(terminalUserList)) {
            return re;
        }
        re = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalUserList, TerminalUser.class, TerminalUserVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isNotEmpty(terminalList)) {
            Object terminalVos;
            Set terminalCodeSet = terminalList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTerminalCode())).map(TerminalUserRelaTerminal::getTerminalCode).collect(Collectors.toSet());
            Map<Object, Object> mapTerminal = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(terminalCodeSet) && CollectionUtils.isNotEmpty((Collection)(terminalVos = this.terminalVoService.findMainDetailsByTerminalCodes((List)Lists.newArrayList(terminalCodeSet))))) {
                mapTerminal = terminalVos.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getTerminalCode(), a.getTerminalName()})).collect(Collectors.toMap(TerminalVo::getTerminalCode, TerminalVo::getTerminalName, (a, b) -> a));
            }
            for (TerminalUserRelaTerminal item : terminalList) {
                item.setTerminalName((String)mapTerminal.get(item.getTerminalCode()));
            }
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalList, TerminalUserRelaTerminal.class, TerminalUserRelaTerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
            map = voList.stream().collect(Collectors.groupingBy(TerminalUserRelaTerminalVo::getUserCode));
        }
        for (TerminalUserVo item : re) {
            item.setTerminalList((List)map.get(item.getUserCode()));
        }
        return re;
    }

    private TerminalUserVo buildByDtoAndTerminalUser(TerminalUserDto dto, TerminalUser terminalUser) {
        if (Objects.isNull((Object)terminalUser) || Objects.isNull(dto)) {
            return null;
        }
        TerminalUserVo vo = (TerminalUserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)terminalUser, TerminalUserVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)dto.getTerminalList())) {
            vo.setTerminalList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getTerminalList(), TerminalUserRelaTerminalDto.class, TerminalUserRelaTerminalVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        return vo;
    }
}

