package com.biz.crm.mdm.business.terminal.user.local.service.notifier;

import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.biz.crm.mdm.business.terminal.sdk.dto.TerminalEventDto;
import com.biz.crm.mdm.business.terminal.sdk.event.TerminalEventListener;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mdm.business.terminal.user.local.service.TerminalUserRelaTerminalService;
import com.google.common.collect.Lists;

/**
 * 终端操作监听实现
 *
 * @author sunx
 * @date 2021/11/3
 */
@Component
public class TerminalEventListenerImpl implements TerminalEventListener {

  @Autowired(required = false) private TerminalUserRelaTerminalService terminalUserRelaTerminalService;

  @Override
  public void onDelete(TerminalEventDto dto) {
    Validate.notNull(dto, "事件通知参数不能为空");
    final TerminalVo original = dto.getOriginal();
    Validate.notNull(original, "删除终端信息不存在");
    Integer count =
        terminalUserRelaTerminalService.countByTerminalCodes(
            Lists.newArrayList(original.getTerminalCode()));
    Validate.isTrue(count < 1, "对应的终端已存在关联的终端用户信息，不能执行删除");
  }
}
