/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.user.local.event;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.terminal.user.sdk.event.TerminalUserEventListener;
import com.biz.crm.mdm.business.terminal.user.sdk.vo.TerminalUserVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TerminalUserEventListenerImpl
implements TerminalUserEventListener {
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    public void onCreate(TerminalUserVo vo) {
        String onlyKey = vo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(null);
        crmBusinessLogDto.setNewObject((Object)vo);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onUpdate(TerminalUserVo oldVo, TerminalUserVo newVo) {
        String onlyKey = newVo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)oldVo);
        crmBusinessLogDto.setNewObject((Object)newVo);
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    public void onEnable(List<TerminalUserVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(terminalUserVo -> {
            String onlyKey = terminalUserVo.getId();
            TerminalUserVo oldObj = new TerminalUserVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            TerminalUserVo newObj = new TerminalUserVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(terminalUserVo.getEnableStatus());
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject((Object)oldObj);
            crmBusinessLogDto.setNewObject((Object)newObj);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    public void onDisable(List<TerminalUserVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(terminalUserVo -> {
            String onlyKey = terminalUserVo.getId();
            TerminalUserVo oldObj = new TerminalUserVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            TerminalUserVo newObj = new TerminalUserVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(terminalUserVo.getEnableStatus());
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject((Object)oldObj);
            crmBusinessLogDto.setNewObject((Object)newObj);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    public void onDelete(List<TerminalUserVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(terminalUserVo -> {
            String onlyKey = terminalUserVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(terminalUserVo);
            crmBusinessLogDto.setNewObject(null);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }
}

