package com.biz.crm.mdm.business.terminal.user.local.event;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.terminal.user.sdk.event.TerminalUserEventListener;
import com.biz.crm.mdm.business.terminal.user.sdk.vo.TerminalUserVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author yangshen
 * @version 1.0
 * @date 2022/12/27 9:46
 * @ClassName TerminalUserEventListenerImpl
 * @Description TODO 终端用户事件监听器实现
 */
@Component
public class TerminalUserEventListenerImpl implements TerminalUserEventListener {


    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    /**
     * 创建时触发
     * @param vo
     */
    @Override
    public void onCreate(TerminalUserVo vo) {
        String onlyKey = vo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(null);
        crmBusinessLogDto.setNewObject(vo);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 编辑时触发
     * @param oldVo 旧数据
     * @param newVo 新数据
     */
    @Override
    public void onUpdate(TerminalUserVo oldVo, TerminalUserVo newVo) {
        String onlyKey = newVo.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(oldVo);
        crmBusinessLogDto.setNewObject(newVo);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 开启时触发
     * @param list 新数据
     */
    @Override
    public void onEnable(List<TerminalUserVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(terminalUserVo -> {
            String onlyKey = terminalUserVo.getId();
            TerminalUserVo oldObj = new TerminalUserVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            TerminalUserVo newObj = new TerminalUserVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(terminalUserVo.getEnableStatus());
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(oldObj);
            crmBusinessLogDto.setNewObject(newObj);
            crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    /**
     * 禁用时触发
     * @param list 新数据
     */
    @Override
    public void onDisable(List<TerminalUserVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(terminalUserVo -> {
            String onlyKey = terminalUserVo.getId();
            TerminalUserVo oldObj = new TerminalUserVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            TerminalUserVo newObj = new TerminalUserVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(terminalUserVo.getEnableStatus());
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(oldObj);
            crmBusinessLogDto.setNewObject(newObj);
            crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    /**
     * 删除时触发
     * @param list
     */
    @Override
    public void onDelete(List<TerminalUserVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(terminalUserVo -> {
            String onlyKey = terminalUserVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(terminalUserVo);
            crmBusinessLogDto.setNewObject(null);
            crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }
}
