package com.biz.crm.mdm.business.terminal.user.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.terminal.user.local.entity.TerminalUserRelaTerminal;
import com.biz.crm.mdm.business.terminal.user.local.mapper.TerminalUserRelaTerminalMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 终端用户与终端关联终端表(repository)
 *
 * @author sunx
 * @since 2021-10-20 16:36:38
 */
@Component
public class TerminalUserRelaTerminalRepository
    extends ServiceImpl<TerminalUserRelaTerminalMapper, TerminalUserRelaTerminal> {

  public List<TerminalUserRelaTerminal> findByUserCodes(List<String> userCodeList) {
    return this.lambdaQuery()
        .eq(TerminalUserRelaTerminal::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalUserRelaTerminal::getUserCode, userCodeList)
        .list();
  }

  public void deleteByUserCodes(List<String> userCodeList) {
    LambdaQueryWrapper<TerminalUserRelaTerminal> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery
        .eq(TerminalUserRelaTerminal::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalUserRelaTerminal::getUserCode, userCodeList);
    baseMapper.delete(lambdaQuery);
  }

  public Integer countByTerminalCodes(List<String> terminalCodeList) {
    return this.lambdaQuery()
        .eq(TerminalUserRelaTerminal::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalUserRelaTerminal::getTerminalCode, terminalCodeList)
        .count();
  }

  /**
   * 根据终端编码集合查询
   *
   * @param terminalCodeList
   * @return
   */
  public List<TerminalUserRelaTerminal> findByTerminalCodes(List<String> terminalCodeList) {
    return this.lambdaQuery()
        .eq(TerminalUserRelaTerminal::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalUserRelaTerminal::getTerminalCode, terminalCodeList)
        .list();
  }
}
