/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.user.local.service.internal;

import com.biz.crm.mdm.business.terminal.user.local.entity.TerminalUser;
import com.biz.crm.mdm.business.terminal.user.local.entity.TerminalUserRelaTerminal;
import com.biz.crm.mdm.business.terminal.user.local.repository.TerminalUserRelaTerminalRepository;
import com.biz.crm.mdm.business.terminal.user.local.service.TerminalUserRelaTerminalService;
import com.biz.crm.mdm.business.terminal.user.local.service.TerminalUserService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="terminalUserRelaTerminalService")
public class TerminalUserRelaTerminalServiceImpl
implements TerminalUserRelaTerminalService {
    @Autowired(required=false)
    private TerminalUserRelaTerminalRepository terminalUserRelaTerminalRepository;
    @Autowired(required=false)
    private TerminalUserService terminalUserService;
    private static volatile Cache<String, List<TerminalUserRelaTerminal>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TerminalUserRelaTerminalServiceImpl() {
        if (cache != null) return;
        Class<TerminalUserRelaTerminalServiceImpl> clazz = TerminalUserRelaTerminalServiceImpl.class;
        synchronized (TerminalUserRelaTerminalServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public List<TerminalUserRelaTerminal> findByUserCodes(List<String> userCodeList) {
        if (CollectionUtils.isEmpty(userCodeList)) {
            return Lists.newLinkedList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), userCodeList});
        List<TerminalUserRelaTerminal> graph = (List<TerminalUserRelaTerminal>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.terminalUserRelaTerminalRepository.findByUserCodes(userCodeList);
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    @Transactional
    public void saveBatch(List<TerminalUserRelaTerminal> list, String userCode) {
        Validate.notBlank((CharSequence)userCode, (String)"\u7ec8\u7aef\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalUserRelaTerminalRepository.deleteByUserCodes(Lists.newArrayList((Object[])new String[]{userCode}));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Optional<TerminalUserRelaTerminal> first = list.stream().filter(a -> StringUtils.isBlank((CharSequence)a.getTerminalCode()) || StringUtils.isBlank((CharSequence)a.getUserCode()) || !userCode.equals(a.getUserCode())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7f16\u7801\u3001\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u7ec8\u7aef\u7528\u6237", (Object[])new Object[0]);
        HashSet set = Sets.newHashSet();
        list.forEach(a -> Validate.isTrue((boolean)set.add(a.getTerminalCode()), (String)"\u5b58\u5728\u91cd\u590d\u7684\u8bb0\u5f55\u4fe1\u606f", (Object[])new Object[0]));
        for (TerminalUserRelaTerminal item : list) {
            item.setId(null);
            item.setTenantCode(TenantUtils.getTenantCode());
        }
        this.terminalUserRelaTerminalRepository.saveBatch(list);
    }

    @Override
    public Integer countByTerminalCodes(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return 0;
        }
        List<TerminalUserRelaTerminal> byTerminalCodes = this.terminalUserRelaTerminalRepository.findByTerminalCodes(terminalCodeList);
        if (CollectionUtils.isEmpty(byTerminalCodes)) {
            return 0;
        }
        List<String> userCodes = byTerminalCodes.stream().map(TerminalUserRelaTerminal::getUserCode).collect(Collectors.toList());
        List<TerminalUser> terminalUsers = this.terminalUserService.findByUserCodes(userCodes);
        if (CollectionUtils.isEmpty(terminalUsers)) {
            return 0;
        }
        return 1;
    }
}

