/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminal.user.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.terminal.user.local.entity.TerminalUser;
import com.biz.crm.mdm.business.terminal.user.local.repository.TerminalUserRepository;
import com.biz.crm.mdm.business.terminal.user.local.service.TerminalUserService;
import com.biz.crm.mdm.business.terminal.user.sdk.dto.TerminalUserPaginationDto;
import com.biz.crm.mdm.business.terminal.user.sdk.dto.TerminalUserResetPasswordDto;
import com.biz.crm.mdm.business.terminal.user.sdk.event.TerminalUserEventListener;
import com.biz.crm.mdm.business.terminal.user.sdk.vo.TerminalUserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.Aes128Utils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;

@Service(value="terminalUserService")
public class TerminalUserServiceImpl
implements TerminalUserService {
    @Autowired(required=false)
    private TerminalUserRepository terminalUserRepository;
    @Autowired(required=false)
    @Lazy
    private List<TerminalUserEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    private static volatile Cache<String, List<TerminalUser>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TerminalUserServiceImpl() {
        if (cache != null) return;
        Class<TerminalUserServiceImpl> clazz = TerminalUserServiceImpl.class;
        synchronized (TerminalUserServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Page<TerminalUser> findByConditions(Pageable pageable, TerminalUserPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new TerminalUserPaginationDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.terminalUserRepository.findByConditions((Page<TerminalUser>)page, dto);
    }

    @Override
    public TerminalUser findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.terminalUserRepository.findById(id);
    }

    @Override
    @Transactional
    public TerminalUser create(TerminalUser terminalUser) {
        Validate.notNull((Object)((Object)terminalUser), (String)"\u7ec8\u7aef\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalUser.getUserName(), (String)"\u7ec8\u7aef\u7528\u6237\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)terminalUser.getUserCode())) {
            terminalUser.setUserCode((String)this.generateCodeService.generateCode("ZDYH", 1).get(0));
        }
        this.createValidation(terminalUser);
        terminalUser.setTenantCode(TenantUtils.getTenantCode());
        terminalUser.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        terminalUser.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.terminalUserRepository.saveOrUpdate((Object)terminalUser);
        return terminalUser;
    }

    @Override
    @Transactional
    public TerminalUser update(TerminalUser terminalUser) {
        this.updateValidation(terminalUser);
        this.terminalUserRepository.saveOrUpdate((Object)terminalUser);
        return terminalUser;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalUserRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        this.onEnableOrDisable(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalUserRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        this.onEnableOrDisable(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalUserRepository.updateDelFlagByIds(ids);
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return;
        }
        List<TerminalUserVo> voList = this.findVoListByIds(ids);
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (TerminalUserEventListener eventListener : this.eventListeners) {
            eventListener.onDelete(voList);
        }
    }

    @Override
    public List<TerminalUser> findDetailsByIdsOrUserCodes(List<String> ids, List<String> userCodes) {
        String cacheKey;
        List<TerminalUser> graph;
        if (CollectionUtils.isEmpty(ids) && CollectionUtils.isEmpty(userCodes)) {
            return Lists.newLinkedList();
        }
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isNotEmpty(ids)) {
            sb.append(StringUtils.join((Object[])new List[]{ids}));
        }
        if (CollectionUtils.isNotEmpty(userCodes)) {
            sb.append(StringUtils.join((Object[])new List[]{userCodes}));
        }
        if ((graph = (List<TerminalUser>)cache.getIfPresent((Object)(cacheKey = StringUtils.join((Object[])new String[]{TenantUtils.getTenantCode(), sb.toString()})))) == null) {
            graph = this.terminalUserRepository.findDetailsByIdsOrUserCodes(ids, userCodes);
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    @Override
    @Transactional
    public void updatePassword(TerminalUserResetPasswordDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getIds()), (String)"\u7ec8\u7aef\u7528\u6237id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String password = Aes128Utils.decrypt((CharSequence)dto.getPassword(), (String)"1234123412ABCDEF", (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
        String md5Password = DigestUtils.md5DigestAsHex((byte[])password.getBytes(StandardCharsets.UTF_8));
        dto.setPassword(md5Password);
        this.terminalUserRepository.updatePassword(dto);
    }

    @Override
    public List<TerminalUser> findByUserCodes(List<String> userCodes) {
        if (CollectionUtils.isEmpty(userCodes)) {
            return Lists.newLinkedList();
        }
        String cacheKey = StringUtils.join((Object[])new Object[]{TenantUtils.getTenantCode(), userCodes});
        List<TerminalUser> graph = (List<TerminalUser>)cache.getIfPresent((Object)cacheKey);
        if (graph == null) {
            graph = this.terminalUserRepository.findByUserCodes(userCodes);
            cache.put((Object)cacheKey, graph);
        }
        return graph;
    }

    private void onEnableOrDisable(List<String> ids, EnableStatusEnum enableStatusEnum) {
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return;
        }
        List<TerminalUserVo> voList = this.findVoListByIds(ids);
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (TerminalUserEventListener event : this.eventListeners) {
            if (enableStatusEnum.equals((Object)EnableStatusEnum.ENABLE)) {
                event.onEnable(voList);
                continue;
            }
            if (!enableStatusEnum.equals((Object)EnableStatusEnum.DISABLE)) continue;
            event.onDisable(voList);
        }
    }

    private List<TerminalUserVo> findVoListByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newLinkedList();
        }
        List<TerminalUser> list = this.findDetailsByIdsOrUserCodes(ids, null);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, TerminalUser.class, TerminalUserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidation(TerminalUser terminalUser) {
        Integer count = this.terminalUserRepository.countByUserCodeOrUserNameCoverDel(terminalUser.getUserCode(), terminalUser.getUserName());
        Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)"\u7528\u6237\u8d26\u53f7\u6216\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalUser.getUserPhone(), (String)"\u7ec8\u7aef\u7528\u6237\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TerminalUser terminalUserByPhone = this.terminalUserRepository.findUserByPhone(terminalUser.getUserPhone());
        Validate.isTrue((boolean)Objects.isNull((Object)terminalUserByPhone), (String)"\u7535\u8bdd\u53f7\u7801\u5df2\u7ecf\u88ab\u5360\u7528", (Object[])new Object[0]);
        String password = Aes128Utils.decrypt((CharSequence)terminalUser.getUserPassword(), (String)"1234123412ABCDEF", (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
        String md5Password = DigestUtils.md5DigestAsHex((byte[])password.getBytes(StandardCharsets.UTF_8));
        terminalUser.setUserPassword(md5Password);
    }

    private void updateValidation(TerminalUser terminalUser) {
        Validate.notNull((Object)((Object)terminalUser), (String)"\u7ec8\u7aef\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalUser.getUserName(), (String)"\u7ec8\u7aef\u7528\u6237\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)terminalUser.getId()), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)terminalUser.getUserPhone(), (String)"\u7ec8\u7aef\u7528\u6237\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        TerminalUser terminalUserByPhone = this.terminalUserRepository.findUserByPhone(terminalUser.getUserPhone());
        if (!Objects.isNull((Object)terminalUserByPhone) && !terminalUserByPhone.getId().equals(terminalUser.getId())) {
            throw new IllegalArgumentException("\u7535\u8bdd\u53f7\u7801\u5df2\u7ecf\u88ab\u5360\u7528");
        }
        String currentId = terminalUser.getId();
        TerminalUser current = this.terminalUserRepository.findById(currentId);
        Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.isTrue((boolean)terminalUser.getUserCode().equals(current.getUserCode()), (String)"\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        Validate.isTrue((boolean)terminalUser.getUserName().equals(current.getUserName()), (String)"\u8d26\u53f7\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)terminalUser.getUserPassword())) {
            String password = Aes128Utils.decrypt((CharSequence)terminalUser.getUserPassword(), (String)"1234123412ABCDEF", (Aes128Utils.EncodeType)Aes128Utils.EncodeType.CBC, (Aes128Utils.Padding)Aes128Utils.Padding.PKCS_7_PADDING);
            if (!password.equals(current.getUserPassword())) {
                String md5Password = DigestUtils.md5DigestAsHex((byte[])password.getBytes(StandardCharsets.UTF_8));
                terminalUser.setUserPassword(md5Password);
            } else {
                terminalUser.setUserPassword(current.getUserPassword());
            }
        } else {
            terminalUser.setUserPassword(current.getUserPassword());
        }
    }
}

