package com.biz.crm.mdm.business.terminal.user.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminal.user.sdk.dto.TerminalUserDto;
import com.biz.crm.mdm.business.terminal.user.sdk.service.TerminalUserVoService;
import com.biz.crm.mdm.business.terminal.user.sdk.vo.TerminalUserVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Optional;

/**
 * 终端用户控制层
 *
 * @author sunx
 * @since 2021-10-20 16:35:06
 */
@Slf4j
@Api(tags = "终端用户: TerminalUserVo: 终端用户")
@RestController
@RequestMapping(value = {"/v1/terminalUser/terminalUser"})
public class TerminalUserVoController {

  @Autowired(required = false)
  private TerminalUserVoService terminalUserVoService;

  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<TerminalUserVo> findDetailById(@RequestParam("id") String id) {
    List<String> ids = Lists.newLinkedList();
    if (StringUtils.isNotBlank(id)) {
      ids.add(id);
    }
    try {
      TerminalUserVo vo = null;
      List<TerminalUserVo> list = terminalUserVoService.findDetailsByIdsOrUserCodes(ids, null);
      Optional<TerminalUserVo> optional = list.stream().findFirst();
      if (optional.isPresent()) {
        vo = optional.get();
      }
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<TerminalUserVo> create(@RequestBody TerminalUserDto dto) {
    try {
      TerminalUserVo vo = this.terminalUserVoService.create(dto);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<TerminalUserVo> update(@RequestBody TerminalUserDto dto) {
    try {
      TerminalUserVo vo = this.terminalUserVoService.update(dto);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "通过用户手机号获取终端用户信息")
  @GetMapping(value = {"/findByUserPhone"})
  public Result<TerminalUserVo> findByUserPhone(@RequestParam("userPhone") String userPhone) {
    try {
      return Result.ok(this.terminalUserVoService.findByUserPhone(userPhone));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  @ApiOperation(value = "通过账号获取终端用户信息")
  @GetMapping(value = {"/findByUserName"})
  public Result<TerminalUserVo> findByUserName(@RequestParam("userName") String userName) {
    try {
      return Result.ok(this.terminalUserVoService.findByUserName(userName));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据编码获取集合
   *
   * @param userCodes
   * @return
   */
  @ApiOperation(value = "通过用户编码获取终端用户信息")
  @GetMapping(value = {"/findDetailsByUserCodes"})
  public Result<List<TerminalUserVo>> findDetailsByUserCodes(@RequestParam("userCodes") List<String> userCodes) {
    try {
      return Result.ok(this.terminalUserVoService.findDetailsByIdsOrUserCodes(null, userCodes));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
