package com.biz.crm.mdm.business.terminal.user.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.terminal.user.local.entity.TerminalUser;
import com.biz.crm.mdm.business.terminal.user.local.mapper.TerminalUserMapper;
import com.biz.crm.mdm.business.terminal.user.sdk.dto.TerminalUserPaginationDto;
import com.biz.crm.mdm.business.terminal.user.sdk.dto.TerminalUserResetPasswordDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 * 终端用户(repository)
 *
 * @author sunx
 * @since 2021-10-20 16:35:04
 */
@Component
public class TerminalUserRepository extends ServiceImpl<TerminalUserMapper, TerminalUser> {

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<TerminalUser> findByConditions(
      Page<TerminalUser> page, TerminalUserPaginationDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    return baseMapper.findByConditions(page, dto);
  }

  public TerminalUser findById(String id) {
//    return this.baseMapper.selectById(id);
    return this.lambdaQuery()
        .eq(TerminalUser::getId, id)
        .eq(TerminalUser::getTenantCode, TenantUtils.getTenantCode())
        .one();
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<TerminalUser> findByIds(List<String> ids) {
    return this.lambdaQuery().in(TerminalUser::getId, ids)
        .eq(TerminalUser::getTenantCode, TenantUtils.getTenantCode())
        .list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(TerminalUser::getId, ids)
        .eq(TerminalUser::getTenantCode, TenantUtils.getTenantCode())
        .set(TerminalUser::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate()
        .in(TerminalUser::getId, ids)
        .eq(TerminalUser::getTenantCode, TenantUtils.getTenantCode())
        .set(TerminalUser::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }

  /**
   * 根据编码获取集合
   *
   * @param userCodes
   * @return
   */
  public List<TerminalUser> findByUserCodes(List<String> userCodes) {
    return this.lambdaQuery()
        .eq(TerminalUser::getTenantCode, TenantUtils.getTenantCode())
        .eq(TerminalUser::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
        .in(TerminalUser::getUserCode, userCodes)
        .list();
  }

  /**
   * 根据id或编码获取集合
   *
   * @param userCodes
   * @return
   */
  public List<TerminalUser> findDetailsByIdsOrUserCodes(List<String> ids, List<String> userCodes) {
    return this.lambdaQuery()
        .eq(TerminalUser::getTenantCode, TenantUtils.getTenantCode())
        .and(
            i ->
                i.in(CollectionUtils.isNotEmpty(ids), TerminalUser::getId, ids)
                    .or()
                    .in(
                        CollectionUtils.isNotEmpty(userCodes),
                        TerminalUser::getUserCode,
                        userCodes))
        .list();
  }

  /**
   * 根据用户编码或者用户名查询用户
   * @param userCode
   * @param userName
   * @return
   */
  public Integer countByUserCodeOrUserName(String userCode, String userName) {
    return lambdaQuery()
        .eq(TerminalUser::getTenantCode, TenantUtils.getTenantCode())
        .eq(TerminalUser::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .and(
            w ->
                w.eq(TerminalUser::getUserCode, userCode)
                    .or()
                    .eq(TerminalUser::getUserName, userName))
        .count();
  }

  /**
   *  根据用户编码或者用户名查询用户 包括已逻辑删除
    * @param userCode
   * @param userName
   * @return
   */
  public Integer countByUserCodeOrUserNameCoverDel(String userCode, String userName) {
    return lambdaQuery()
        .eq(TerminalUser::getTenantCode, TenantUtils.getTenantCode())
        .and(
            w ->
                w.eq(TerminalUser::getUserCode, userCode)
                    .or()
                    .eq(TerminalUser::getUserName, userName))
        .count();
  }

  /**
   * 重置密码
   *
   * @param dto
   */
  public void updatePassword(TerminalUserResetPasswordDto dto) {
    lambdaUpdate()
        .eq(TerminalUser::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalUser::getId, dto.getIds())
        .set(TerminalUser::getUserPassword, dto.getPassword())
        .set(TerminalUser::getUpdatePasswordDate, new Date())
        .update();
  }

  /**
   * 根据手机号查询账号
   *
   * @param userPhone
   * @return
   */
  public TerminalUser findUserByPhone(String userPhone) {
    return lambdaQuery()
        .eq(TerminalUser::getTenantCode, TenantUtils.getTenantCode())
        .eq(TerminalUser::getUserPhone, userPhone)
        .one();
  }

  /**
   * 根据账号查询账号
   *
   * @param userName
   * @return
   */
  public TerminalUser findUserByUserName(String userName) {
    return lambdaQuery()
      .eq(TerminalUser::getTenantCode, TenantUtils.getTenantCode())
      .eq(TerminalUser::getUserName, userName)
      .one();
  }
}
