package com.biz.crm.mdm.business.terminal.user.sdk.service;

import com.biz.crm.mdm.business.terminal.user.sdk.dto.TerminalUserDto;
import com.biz.crm.mdm.business.terminal.user.sdk.vo.TerminalUserVo;
import java.util.List;

/**
 * 终端用户Vo接口
 *
 * @author sunx
 * @since 2021-10-20 16:37:36
 */
public interface TerminalUserVoService {

  /**
   * 根据id或编码获取集合
   *
   * @param ids
   * @param userCodes
   * @return
   */
  List<TerminalUserVo> findDetailsByIdsOrUserCodes(List<String> ids, List<String> userCodes);

  /**
   * 新增
   *
   * @param dto
   * @return
   */
  TerminalUserVo create(TerminalUserDto dto);

  /**
   * 编辑
   *
   * @param dto
   * @return
   */
  TerminalUserVo update(TerminalUserDto dto);

  /**
   * 通过用户手机号获取终端用户信息
   *
   * @param userPhone 用户手机号
   * @return 终端用户信息
   */
  TerminalUserVo findByUserPhone(String userPhone);

  /**
   * 通过用户账号获取终端用户信息
   *
   * @param userName 用户账号
   * @return 终端用户信息
   */
  TerminalUserVo findByUserName(String userName);
}
