package com.biz.crm.mdm.business.terminaluser.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.mdm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 终端用户与终端关联终端表(TerminalUserRTerminal)实体类
 *
 * @author sunx
 * @since 2021-10-20 16:36:37
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_terminal_user_r_terminal")
@Table(name = "mdm_terminal_user_r_terminal", indexes = {
    @Index(name = "mdm_terminal_user_r_terminal_index1", columnList = "user_code"),
    @Index(name = "mdm_terminal_user_r_terminal_index2", columnList = "terminal_code"),
    @Index(name = "mdm_terminal_user_r_terminal_index3", columnList = "tenant_code")
})
@org.hibernate.annotations.Table(appliesTo = "mdm_terminal_user_r_terminal", comment = "终端用户与终端关联终端表")
@ApiModel(value = "TerminalUserRTerminal", description = "终端用户与终端关联终端表")
public class TerminalUserRTerminal extends TenantEntity {

  /**
   * 是否是主终端标记
   */
  @ApiModelProperty("是否是主终端标记")
  @TableField(value = "primary_flag")
  @Column(name = "primary_flag", columnDefinition = "int COMMENT '是否是主终端标记'")
  private Boolean primaryFlag;

  /**
   * 用户编码
   */
  @ApiModelProperty("用户编码")
  @TableField(value = "user_code")
  @Column(name = "user_code", length = 32, columnDefinition = "varchar(32) COMMENT '用户编码'")
  private String userCode;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", length = 32, columnDefinition = "varchar(32) COMMENT '终端编码'")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  @TableField(value = "terminal_name")
  @Column(name = "terminal_name", length = 60, columnDefinition = "varchar(60) COMMENT '终端名称'")
  private String terminalName;

  /**
   * 是否是当前终端标记
   */
  @ApiModelProperty("是否是当前终端标记")
  @TableField(value = "current_flag")
  @Column(name = "current_flag", columnDefinition = "int COMMENT '是否是当前终端标记'")
  private Boolean currentFlag;

}
