package com.biz.crm.mdm.business.terminaluser.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.terminaluser.local.entity.TerminalUserRTerminal;
import com.biz.crm.mdm.business.terminaluser.local.mapper.TerminalUserRTerminalMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 终端用户与终端关联终端表(repository)
 *
 * @author sunx
 * @since 2021-10-20 16:36:38
 */
@Component
public class TerminalUserRTerminalRepository extends
    ServiceImpl<TerminalUserRTerminalMapper, TerminalUserRTerminal> {

  public List<TerminalUserRTerminal> findByUserCodes(List<String> userCodeList) {
    return this.lambdaQuery().eq(TerminalUserRTerminal::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalUserRTerminal::getUserCode, userCodeList).list();
  }

  public void deleteByUserCodes(List<String> userCodeList) {
    LambdaQueryWrapper<TerminalUserRTerminal> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(TerminalUserRTerminal::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalUserRTerminal::getUserCode, userCodeList);
    baseMapper.delete(lambdaQuery);
  }
}
