package com.biz.crm.mdm.business.terminaluser.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.terminaluser.local.entity.TerminalUser;
import com.biz.crm.mdm.business.terminaluser.local.mapper.TerminalUserMapper;
import com.biz.crm.mdm.business.terminaluser.sdk.dto.TerminalUserPaginationDto;
import com.biz.crm.mdm.business.terminaluser.sdk.dto.TerminalUserResetPasswordDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

/**
 * 终端用户(repository)
 *
 * @author sunx
 * @since 2021-10-20 16:35:04
 */
@Component
public class TerminalUserRepository extends ServiceImpl<TerminalUserMapper, TerminalUser> {

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<TerminalUser> findByConditions(Page<TerminalUser> page,
      TerminalUserPaginationDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    return baseMapper.findByConditions(page, dto);
  }

  public TerminalUser findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<TerminalUser> findByIds(List<String> ids) {
    return this.lambdaQuery().in(TerminalUser::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate().in(TerminalUser::getId, ids)
        .set(TerminalUser::getEnableStatus, enable.getCode()).update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate().in(TerminalUser::getId, ids)
        .set(TerminalUser::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
  }

  /**
   * 根据编码获取集合
   *
   * @param userCodes
   * @return
   */
  public List<TerminalUser> findByUserCodes(List<String> userCodes) {
    return this.lambdaQuery().eq(TerminalUser::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalUser::getUserCode, userCodes).list();
  }

  public Integer countByUserCode(String userCode) {
    return lambdaQuery().eq(TerminalUser::getTenantCode, TenantUtils.getTenantCode())
        .eq(TerminalUser::getUserCode, userCode).count();
  }

  /**
   * 重置密码
   *
   * @param dto
   */
  public void resetPassword(TerminalUserResetPasswordDto dto) {
    lambdaUpdate().eq(TerminalUser::getTenantCode, TenantUtils.getTenantCode())
        .in(TerminalUser::getId, dto.getIds())
        .set(TerminalUser::getUserPassword, dto.getPassword())
        .set(TerminalUser::getUpdatePasswordDate, new Date()).update();
  }
}
