package com.biz.crm.mdm.business.terminaluser.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.terminaluser.local.entity.TerminalUser;
import com.biz.crm.mdm.business.terminaluser.sdk.dto.TerminalUserPaginationDto;
import com.biz.crm.mdm.business.terminaluser.sdk.dto.TerminalUserResetPasswordDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 终端用户(TerminalUser)表服务接口
 *
 * @author sunx
 * @since 2021-10-20 16:35:05
 */
public interface TerminalUserService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<TerminalUser> findByConditions(Pageable pageable, TerminalUserPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  TerminalUser findDetailById(String id);

  /**
   * 创建
   *
   * @param terminalUser
   * @return
   */
  TerminalUser create(TerminalUser terminalUser);

  /**
   * 更新
   *
   * @param terminalUser
   * @return
   */
  TerminalUser update(TerminalUser terminalUser);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 根据id或编码获取集合
   *
   * @param ids
   * @param userCodes
   * @return
   */
  List<TerminalUser> findDetailsByIdsOrUserCodes(List<String> ids, List<String> userCodes);

  /**
   * 重置密码
   *
   * @param dto
   */
  void resetPassword(TerminalUserResetPasswordDto dto);
}
