package com.biz.crm.mdm.business.terminaluser.local.service.internal;

import com.biz.crm.mdm.business.terminaluser.local.entity.TerminalUserRTerminal;
import com.biz.crm.mdm.business.terminaluser.local.repository.TerminalUserRTerminalRepository;
import com.biz.crm.mdm.business.terminaluser.local.service.TerminalUserRTerminalService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 终端用户与终端关联终端表(TerminalUserRTerminal)表服务实现类
 *
 * @author sunx
 * @since 2021-10-20 16:36:39
 */
@Slf4j
@Service("terminalUserRTerminalService")
public class TerminalUserRTerminalServiceImpl implements TerminalUserRTerminalService {

  @Autowired
  private TerminalUserRTerminalRepository terminalUserRTerminalRepository;

  @Override
  public List<TerminalUserRTerminal> findByUserCodes(List<String> userCodeList) {
    if (CollectionUtils.isEmpty(userCodeList)) {
      return Lists.newArrayList();
    }
    return terminalUserRTerminalRepository.findByUserCodes(userCodeList);
  }

  @Override
  @Transactional
  public void saveBatch(List<TerminalUserRTerminal> list, String userCode) {
    Validate.notBlank(userCode, "终端用户编码不能为空");
    terminalUserRTerminalRepository.deleteByUserCodes(Lists.newArrayList(userCode));
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    Optional<TerminalUserRTerminal> first = list.stream().filter(
        a -> StringUtils.isBlank(a.getTerminalCode())
            || StringUtils.isBlank(a.getUserCode())
            || !userCode.equals(a.getUserCode()))
        .findFirst();
    Validate.isTrue(!first.isPresent(), "终端编码、用户编码不能为空,且必须属于同一终端用户");
    Set<String> set = Sets.newHashSet();
    list.forEach(a -> {
      Validate.isTrue(set.add(a.getUserCode()), "存在重复的记录信息");
    });

    for (TerminalUserRTerminal item : list) {
      item.setId(null);
      item.setTenantCode(TenantUtils.getTenantCode());
    }
    terminalUserRTerminalRepository.saveBatch(list);
  }
}
