/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminaluser.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.terminaluser.sdk.dto.TerminalUserDto;
import com.biz.crm.mdm.business.terminaluser.sdk.service.TerminalUserVoService;
import com.biz.crm.mdm.business.terminaluser.sdk.vo.TerminalUserVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec8\u7aef\u7528\u6237: TerminalUserVo: \u7ec8\u7aef\u7528\u6237"})
@RestController
@RequestMapping(value={"/v1/terminaluser/terminaluser"})
public class TerminalUserVoController {
    private static final Logger log = LoggerFactory.getLogger(TerminalUserVoController.class);
    @Autowired
    private TerminalUserVoService terminalUserVoService;

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<TerminalUserVo> findDetailById(@RequestParam(value="id") String id) {
        ArrayList ids = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            ids.add(id);
        }
        try {
            TerminalUserVo vo = null;
            List list = this.terminalUserVoService.findDetailsByIdsOrUserCodes((List)ids, null);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                vo = (TerminalUserVo)list.stream().findFirst().get();
            }
            return Result.ok(vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<TerminalUserVo> create(@RequestBody TerminalUserDto dto) {
        try {
            TerminalUserVo vo = this.terminalUserVoService.create(dto);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<TerminalUserVo> update(@RequestBody TerminalUserDto dto) {
        try {
            TerminalUserVo vo = this.terminalUserVoService.update(dto);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

