/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminaluser.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.terminaluser.local.entity.TerminalUser;
import com.biz.crm.mdm.business.terminaluser.local.mapper.TerminalUserMapper;
import com.biz.crm.mdm.business.terminaluser.sdk.dto.TerminalUserPaginationDto;
import com.biz.crm.mdm.business.terminaluser.sdk.dto.TerminalUserResetPasswordDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class TerminalUserRepository
extends ServiceImpl<TerminalUserMapper, TerminalUser> {
    public Page<TerminalUser> findByConditions(Page<TerminalUser> page, TerminalUserPaginationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((TerminalUserMapper)this.baseMapper).findByConditions(page, dto);
    }

    public TerminalUser findById(String id) {
        return (TerminalUser)((Object)((TerminalUserMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<TerminalUser> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<TerminalUser> findByUserCodes(List<String> userCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(TerminalUser::getUserCode, userCodes)).list();
    }

    public Integer countByUserCodeOrUserName(String userCode, String userName) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)w.eq(TerminalUser::getUserCode, (Object)userCode)).or()).eq(TerminalUser::getUserName, (Object)userName);
        })).count();
    }

    public void resetPassword(TerminalUserResetPasswordDto dto) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, (Collection)dto.getIds())).set(TerminalUser::getUserPassword, (Object)dto.getPassword())).set(TerminalUser::getUpdatePasswordDate, (Object)new Date())).update();
    }
}

