/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminaluser.local.service.internal;

import com.biz.crm.mdm.business.terminaluser.local.entity.TerminalUserRTerminal;
import com.biz.crm.mdm.business.terminaluser.local.repository.TerminalUserRTerminalRepository;
import com.biz.crm.mdm.business.terminaluser.local.service.TerminalUserRTerminalService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="terminalUserRTerminalService")
public class TerminalUserRTerminalServiceImpl
implements TerminalUserRTerminalService {
    @Autowired
    private TerminalUserRTerminalRepository terminalUserRTerminalRepository;

    @Override
    public List<TerminalUserRTerminal> findByUserCodes(List<String> userCodeList) {
        if (CollectionUtils.isEmpty(userCodeList)) {
            return Lists.newArrayList();
        }
        return this.terminalUserRTerminalRepository.findByUserCodes(userCodeList);
    }

    @Override
    @Transactional
    public void saveBatch(List<TerminalUserRTerminal> list, String userCode) {
        Validate.notBlank((CharSequence)userCode, (String)"\u7ec8\u7aef\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.terminalUserRTerminalRepository.deleteByUserCodes(Lists.newArrayList((Object[])new String[]{userCode}));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Optional<TerminalUserRTerminal> first = list.stream().filter(a -> StringUtils.isBlank((CharSequence)a.getTerminalCode()) || StringUtils.isBlank((CharSequence)a.getUserCode()) || !userCode.equals(a.getUserCode())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7f16\u7801\u3001\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u7ec8\u7aef\u7528\u6237", (Object[])new Object[0]);
        HashSet set = Sets.newHashSet();
        list.forEach(a -> Validate.isTrue((boolean)set.add(a.getUserCode()), (String)"\u5b58\u5728\u91cd\u590d\u7684\u8bb0\u5f55\u4fe1\u606f", (Object[])new Object[0]));
        for (TerminalUserRTerminal item : list) {
            item.setId(null);
            item.setTenantCode(TenantUtils.getTenantCode());
        }
        this.terminalUserRTerminalRepository.saveBatch(list);
    }

    @Override
    public Integer countByTerminalCodes(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return 0;
        }
        return this.terminalUserRTerminalRepository.countByTerminalCodes(terminalCodeList);
    }
}

