/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.terminaluser.local.service.internal;

import com.biz.crm.mdm.business.terminaluser.local.entity.TerminalUser;
import com.biz.crm.mdm.business.terminaluser.local.entity.TerminalUserRTerminal;
import com.biz.crm.mdm.business.terminaluser.local.service.TerminalUserRTerminalService;
import com.biz.crm.mdm.business.terminaluser.local.service.TerminalUserService;
import com.biz.crm.mdm.business.terminaluser.sdk.dto.TerminalUserDto;
import com.biz.crm.mdm.business.terminaluser.sdk.dto.TerminalUserRTerminalDto;
import com.biz.crm.mdm.business.terminaluser.sdk.event.TerminalUserEventListener;
import com.biz.crm.mdm.business.terminaluser.sdk.service.TerminalUserVoService;
import com.biz.crm.mdm.business.terminaluser.sdk.vo.TerminalUserRTerminalVo;
import com.biz.crm.mdm.business.terminaluser.sdk.vo.TerminalUserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TerminalUserVoServiceImpl
implements TerminalUserVoService {
    @Autowired
    private TerminalUserService terminalUserService;
    @Autowired
    private TerminalUserRTerminalService terminalUserRTerminalService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<TerminalUserEventListener> eventListeners;

    public List<TerminalUserVo> findDetailsByIdsOrUserCodes(List<String> ids, List<String> userCodes) {
        List<Object> re = Lists.newArrayList();
        if (CollectionUtils.isEmpty(ids) && CollectionUtils.isEmpty(userCodes)) {
            return re;
        }
        List<TerminalUser> terminalUserList = this.terminalUserService.findDetailsByIdsOrUserCodes(ids, userCodes);
        if (CollectionUtils.isEmpty(terminalUserList)) {
            return re;
        }
        List<String> userCodeList = terminalUserList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getUserCode())).map(TerminalUser::getUserCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userCodeList)) {
            return re;
        }
        List<TerminalUserRTerminal> terminalList = this.terminalUserRTerminalService.findByUserCodes(userCodeList);
        re = this.buildTerminalUserVoList(terminalUserList, terminalList);
        return re;
    }

    @Transactional
    public TerminalUserVo create(TerminalUserDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        TerminalUser terminalUser = (TerminalUser)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TerminalUser.class, HashSet.class, ArrayList.class, new String[0]));
        this.terminalUserService.create(terminalUser);
        dto.setUserCode(terminalUser.getUserCode());
        this.bindExtInfo(dto);
        TerminalUserVo re = this.buildByDtoAndTerminalUser(dto, terminalUser);
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return re;
        }
        for (TerminalUserEventListener eventListener : this.eventListeners) {
            eventListener.onCreate(re);
        }
        return re;
    }

    @Transactional
    public TerminalUserVo update(TerminalUserDto dto) {
        List<TerminalUserVo> list;
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Boolean flag = CollectionUtils.isNotEmpty(this.eventListeners);
        TerminalUserVo oldVo = null;
        if (flag.booleanValue() && CollectionUtils.isNotEmpty(list = this.findDetailsByIdsOrUserCodes(Lists.newArrayList((Object[])new String[]{dto.getId()}), null))) {
            oldVo = list.get(0);
        }
        TerminalUser terminalUser = (TerminalUser)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TerminalUser.class, HashSet.class, ArrayList.class, new String[0]));
        this.terminalUserService.update(terminalUser);
        dto.setUserCode(terminalUser.getUserCode());
        this.bindExtInfo(dto);
        TerminalUserVo re = this.buildByDtoAndTerminalUser(dto, terminalUser);
        if (!flag.booleanValue()) {
            return re;
        }
        for (TerminalUserEventListener eventListener : this.eventListeners) {
            eventListener.onUpdate(oldVo, re);
        }
        return re;
    }

    @Transactional
    public void bindExtInfo(TerminalUserDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ec8\u7aef\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        List terminalList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getTerminalList())) {
            for (TerminalUserRTerminalDto item : dto.getTerminalList()) {
                item.setUserCode(dto.getUserCode());
            }
            terminalList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getTerminalList(), TerminalUserRTerminalDto.class, TerminalUserRTerminal.class, HashSet.class, ArrayList.class, new String[0]);
            terminalList.forEach(a -> a.setUserCode(dto.getUserCode()));
        }
        this.terminalUserRTerminalService.saveBatch(terminalList, dto.getUserCode());
    }

    private List<TerminalUserVo> buildTerminalUserVoList(List<TerminalUser> terminalUserList, List<TerminalUserRTerminal> terminalList) {
        List<TerminalUserVo> re = Lists.newArrayList();
        Map<Object, Object> map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(terminalUserList)) {
            return re;
        }
        re = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalUserList, TerminalUser.class, TerminalUserVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isNotEmpty(terminalList)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(terminalList, TerminalUserRTerminal.class, TerminalUserRTerminalVo.class, HashSet.class, ArrayList.class, new String[0]);
            map = voList.stream().collect(Collectors.groupingBy(TerminalUserRTerminalVo::getUserCode));
        }
        for (TerminalUserVo item : re) {
            item.setTerminalList((List)map.get(item.getUserCode()));
        }
        return re;
    }

    private TerminalUserVo buildByDtoAndTerminalUser(TerminalUserDto dto, TerminalUser terminalUser) {
        if (Objects.isNull((Object)terminalUser) || Objects.isNull(dto)) {
            return null;
        }
        TerminalUserVo vo = (TerminalUserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)terminalUser, TerminalUserVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)dto.getTerminalList())) {
            vo.setTerminalList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getTerminalList(), TerminalUserRTerminalDto.class, TerminalUserRTerminalVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        return vo;
    }
}

